/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.ghrelease;

import ca.stellardrift.ghrelease.ReleaseJobParameters;
import java.io.File;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHReleaseUpdater;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.GitHubRateLimitHandler;
import org.kohsuke.github.connector.GitHubConnectorResponse;

public abstract class PublishGitHubRelease
extends DefaultTask
implements ReleaseJobParameters {
    @Input
    @Optional
    public abstract Property<String> getEnterpriseUrl();

    @Input
    public abstract Property<String> getApiToken();

    private GitHub createGitHub() {
        GitHubBuilder builder = new GitHubBuilder();
        if (this.getEnterpriseUrl().isPresent()) {
            builder.withEndpoint((String)this.getEnterpriseUrl().get());
        }
        builder.withOAuthToken((String)this.getApiToken().get());
        builder.withRateLimitHandler(new GitHubRateLimitHandler(){

            public void onError(@NotNull GitHubConnectorResponse response) throws IOException {
                PublishGitHubRelease.this.getLogger().error("Exceeded rate limit while trying to publish release (code {}): {}", (Object)response.statusCode(), (Object)new String(response.bodyStream().readAllBytes()));
                throw new GradleException("Rate limit exceeded! See log for details");
            }
        });
        try {
            return builder.build();
        }
        catch (IOException e) {
            this.getLogger().error("Failed to create GitHub instance: {}", (Object)e.getMessage(), (Object)e);
            throw new GradleException("GitHub authentication failed, see log for details");
        }
    }

    @TaskAction
    public void doPublish() {
        GitHub gh = this.createGitHub();
        GHRepository repo = this.runHandlingException(() -> gh.getRepository((String)this.getRepository().get()));
        GHReleaseBuilder releaseBuilder = repo.createRelease((String)this.getTagName().get());
        if (this.getReleaseName().isPresent()) {
            releaseBuilder.name((String)this.getReleaseName().get());
        }
        releaseBuilder.body((String)this.getReleaseBody().getOrElse((Object)"")).draft(true).prerelease(((Boolean)this.getPrerelease().get()).booleanValue());
        if (this.getDiscussionCategoryName().isPresent()) {
            releaseBuilder.categoryName((String)this.getDiscussionCategoryName().get());
        }
        if (this.getSourceBranch().isPresent()) {
            releaseBuilder.commitish((String)this.getSourceBranch().get());
        }
        if (this.getMakeLatest().isPresent()) {
            GHReleaseBuilder.MakeLatest makeLatest;
            switch ((ReleaseJobParameters.LatestState)((Object)this.getMakeLatest().get())) {
                case TRUE: {
                    makeLatest = GHReleaseBuilder.MakeLatest.TRUE;
                    break;
                }
                case FALSE: {
                    makeLatest = GHReleaseBuilder.MakeLatest.FALSE;
                    break;
                }
                case LEGACY: {
                    makeLatest = GHReleaseBuilder.MakeLatest.LEGACY;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown latest state " + this.getMakeLatest().get());
                }
            }
            releaseBuilder.makeLatest(makeLatest);
        }
        GHRelease release = this.runHandlingException(() -> ((GHReleaseBuilder)releaseBuilder).create());
        for (File file : this.getArtifacts()) {
            if (!file.isFile()) {
                throw new InvalidUserDataException("Release artifact " + file.getAbsolutePath() + " is not a regular file!");
            }
            this.runHandlingException(() -> release.uploadAsset(file, this.determineMimeType(file)));
        }
        if (!((Boolean)this.getDraft().get()).booleanValue()) {
            this.runHandlingException(() -> ((GHReleaseUpdater)release.update().draft(false)).update());
        }
    }

    private String determineMimeType(File file) {
        String name = file.getName();
        if (name.endsWith("jar")) {
            return "application/java-archive";
        }
        if (name.endsWith("zip")) {
            return "application/zip";
        }
        return "application/octet-stream";
    }

    private <T> T runHandlingException(GHCallable<T> item) throws GradleException {
        try {
            return item.execute();
        }
        catch (IOException ex) {
            this.getLogger().error("Failed to execute GitHub API operation", (Throwable)ex);
            throw new GradleException("GitHub API error occurred, see log for details: " + ex.getMessage());
        }
    }

    @FunctionalInterface
    static interface GHCallable<O> {
        public O execute() throws IOException;
    }
}

