/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.logback;

import ca.pjer.logback.AwsLogsAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.nio.charset.Charset;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;

abstract class Worker {
    private AwsLogsAppender awsLogsAppender;
    private static final int MAX_EVENT_SIZE = 262144;
    private static final int EVENT_SIZE_PADDING = 26;
    private static final Charset EVENT_SIZE_CHARSET = Charset.forName("UTF-8");
    private static final String ELLIPSIS = "...";

    Worker(AwsLogsAppender awsLogsAppender) {
        this.awsLogsAppender = awsLogsAppender;
    }

    AwsLogsAppender getAwsLogsAppender() {
        return this.awsLogsAppender;
    }

    public synchronized void start() {
    }

    public synchronized void stop() {
    }

    public abstract void append(ILoggingEvent var1);

    InputLogEvent asInputLogEvent(ILoggingEvent event) {
        String message = this.awsLogsAppender.encode(event);
        if (Worker.eventSize(message) > 262144) {
            this.awsLogsAppender.addWarn(String.format("Log message exceeded Cloudwatch Log's limit of %d bytes", 262144));
            message = Worker.trimMessage(message, 262144);
        }
        return (InputLogEvent)InputLogEvent.builder().timestamp(Long.valueOf(event.getTimeStamp())).message(message).build();
    }

    static final int eventSize(InputLogEvent event) {
        return Worker.eventSize(event.message());
    }

    static final int eventSize(String message) {
        return message.getBytes(EVENT_SIZE_CHARSET).length + 26;
    }

    private static final String trimMessage(String message, int eventSize) {
        int trimmedMessageSize = eventSize - 26 - ELLIPSIS.getBytes(EVENT_SIZE_CHARSET).length;
        byte[] messageBytes = message.getBytes(EVENT_SIZE_CHARSET);
        String unsafeTrimmed = new String(messageBytes, 0, trimmedMessageSize + 1, EVENT_SIZE_CHARSET);
        String trimmed = unsafeTrimmed.substring(0, unsafeTrimmed.length() - 1);
        return trimmed + ELLIPSIS;
    }
}

