/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import io.envoyproxy.pgv.CollectiveValidation;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.MapValidation;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.TimestampValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import tests.harness.cases.KitchenSink;

public class KitchenSinkValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(KitchenSink.ComplexTestMsg.class)) {
            return new ComplexTestMsgValidator();
        }
        if (clazz.equals(KitchenSink.KitchenSinkMessage.class)) {
            return new KitchenSinkMessageValidator();
        }
        return null;
    }

    public static class ComplexTestMsgValidator
    implements ValidatorImpl<KitchenSink.ComplexTestMsg> {
        private final Integer INT_CONST__CONST = 5;
        private final Float FLOAT_VAL__GT = Float.valueOf(0.0f);
        private final Duration DUR_VAL__LT = TimestampValidation.toDuration((long)17L, (long)0L);
        private final Timestamp TS_VAL__GT = TimestampValidation.toTimestamp((long)7L, (int)0);
        private final Float FLOAT_CONST__LT = Float.valueOf(8.0f);
        private final Double[] DOUBLE_IN__IN = new Double[]{456.789, 123.0};
        private final String[] ANY_VAL__IN = new String[]{"type.googleapis.com/google.protobuf.Duration"};
        private final Timestamp REP_TS_VAL__GTE = TimestampValidation.toTimestamp((long)0L, (int)1000000);
        private final Integer MAP_VAL_KEY_LT = 0;
        private final ByteString BYTES_VAL__CONST = ByteString.copyFrom((byte[])new byte[]{0, -103});

        public void assertValid(KitchenSink.ComplexTestMsg proto, ValidatorIndex index) throws ValidationException {
            ConstantValidation.constant((String)".tests.harness.cases.ComplexTestMsg.const", (Object)proto.getConst(), (Object)"abcd");
            if (proto.hasNested()) {
                index.validatorFor((Object)proto.getNested()).assertValid((Object)proto.getNested());
            }
            ConstantValidation.constant((String)".tests.harness.cases.ComplexTestMsg.int_const", (Object)proto.getIntConst(), (Object)this.INT_CONST__CONST);
            ConstantValidation.constant((String)".tests.harness.cases.ComplexTestMsg.bool_const", (Object)proto.getBoolConst(), (Object)false);
            if (proto.hasFloatVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.ComplexTestMsg.float_val", (Object)Float.valueOf(proto.getFloatVal().getValue()), (Object)this.FLOAT_VAL__GT, Comparator.naturalOrder());
            }
            if (proto.hasDurVal()) {
                RequiredValidation.required((String)".tests.harness.cases.ComplexTestMsg.dur_val", (Message)proto.getDurVal());
            } else {
                RequiredValidation.required((String)".tests.harness.cases.ComplexTestMsg.dur_val", null);
            }
            if (proto.hasDurVal()) {
                ComparativeValidation.lessThan((String)".tests.harness.cases.ComplexTestMsg.dur_val", (Object)proto.getDurVal(), (Object)this.DUR_VAL__LT, (Comparator)Durations.comparator());
            }
            if (proto.hasTsVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.ComplexTestMsg.ts_val", (Object)proto.getTsVal(), (Object)this.TS_VAL__GT, (Comparator)Timestamps.comparator());
            }
            if (proto.hasAnother()) {
                index.validatorFor((Object)proto.getAnother()).assertValid((Object)proto.getAnother());
            }
            ComparativeValidation.lessThan((String)".tests.harness.cases.ComplexTestMsg.float_const", (Object)Float.valueOf(proto.getFloatConst()), (Object)this.FLOAT_CONST__LT, Comparator.naturalOrder());
            CollectiveValidation.in((String)".tests.harness.cases.ComplexTestMsg.double_in", (Object)proto.getDoubleIn(), (Object[])this.DOUBLE_IN__IN);
            ConstantValidation.constant((String)".tests.harness.cases.ComplexTestMsg.enum_const", (Object)((Object)proto.getEnumConst()), (Object)((Object)KitchenSink.ComplexTestEnum.forNumber(2)));
            if (proto.hasAnyVal()) {
                CollectiveValidation.in((String)".tests.harness.cases.ComplexTestMsg.any_val", (Object)proto.getAnyVal().getTypeUrl(), (Object[])this.ANY_VAL__IN);
            }
            RepeatedValidation.forEach(proto.getRepTsValList(), item -> ComparativeValidation.greaterThanOrEqual((String)".tests.harness.cases.ComplexTestMsg.rep_ts_val", (Object)item, (Object)this.REP_TS_VAL__GTE, (Comparator)Timestamps.comparator()));
            MapValidation.validateParts(proto.getMapValMap().keySet(), key -> ComparativeValidation.lessThan((String)".tests.harness.cases.ComplexTestMsg.map_val", (Object)key, (Object)this.MAP_VAL_KEY_LT, Comparator.naturalOrder()));
            MapValidation.validateParts(proto.getMapValMap().values(), value -> {});
            ConstantValidation.constant((String)".tests.harness.cases.ComplexTestMsg.bytes_val", (Object)proto.getBytesVal(), (Object)this.BYTES_VAL__CONST);
            switch (proto.getOCase()) {
                case X: {
                    break;
                }
                case Y: {
                    break;
                }
                default: {
                    RequiredValidation.required((String)".tests.harness.cases.ComplexTestMsg.o", null);
                }
            }
        }
    }

    public static class KitchenSinkMessageValidator
    implements ValidatorImpl<KitchenSink.KitchenSinkMessage> {
        public void assertValid(KitchenSink.KitchenSinkMessage proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
            }
        }
    }
}

