/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.rio.dhcp;

import br.com.objectos.rio.dhcp.DhcpServerConfiguration;
import br.com.objectos.rio.dhcp.Host;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DhcpServerConfigurationEdit {
    private final DhcpServerConfiguration configuration;
    private final List<Command> commandList = new ArrayList<Command>();

    DhcpServerConfigurationEdit(DhcpServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public DhcpServerConfigurationEdit addHost(Host host) {
        Objects.requireNonNull(host);
        this.commandList.add(new AddHost(host));
        return this;
    }

    public DhcpServerConfigurationEdit clear() {
        this.commandList.add(Clear.INSTANCE);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        DhcpServerConfiguration dhcpServerConfiguration = this.configuration;
        synchronized (dhcpServerConfiguration) {
            this.configuration.lock();
            for (Command command : this.commandList) {
                command.execute(this.configuration);
            }
        }
    }

    private static abstract class Command {
        private Command() {
        }

        abstract void execute(DhcpServerConfiguration var1);
    }

    private static class Clear
    extends Command {
        static final Command INSTANCE = new Clear();

        private Clear() {
        }

        @Override
        void execute(DhcpServerConfiguration configuration) {
            configuration.clear();
        }
    }

    private static class AddHost
    extends Command {
        private final Host host;

        public AddHost(Host host) {
            this.host = host;
        }

        @Override
        void execute(DhcpServerConfiguration configuration) {
            configuration.addHost(this.host);
        }
    }
}

