/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.rio.dhcp;

import br.com.objectos.core.util.ImmutableList;
import br.com.objectos.rio.dhcp.ConfiguredAdapter;
import br.com.objectos.rio.dhcp.DhcpServerConfigurationEdit;
import br.com.objectos.rio.dhcp.Host;
import br.com.objectos.rio.dhcp.ServerConfiguredAdapter;
import br.com.objectos.rio.net.HardwareAddress;
import br.com.objectos.rio.net.IpAddress;
import java.util.List;
import java.util.Map;

public class DhcpServerConfiguration {
    private final IpAddress ipAddress;
    private final int port;
    private final Map<HardwareAddress, ServerConfiguredAdapter> configuredAdapterMap;

    DhcpServerConfiguration(IpAddress ipAddress, int port, Map<HardwareAddress, ServerConfiguredAdapter> configuredAdapterMap) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.configuredAdapterMap = configuredAdapterMap;
    }

    public List<ConfiguredAdapter> configuredAdapterList() {
        return ImmutableList.copyOf(this.configuredAdapterMap.values());
    }

    public DhcpServerConfigurationEdit edit() {
        return new DhcpServerConfigurationEdit(this);
    }

    void addHost(Host host) {
        ServerConfiguredAdapter configuredAdapter = host.toConfiguredAdapter(this.ipAddress);
        this.configuredAdapterMap.put(configuredAdapter.hardwareAddress(), configuredAdapter);
    }

    void clear() {
        this.configuredAdapterMap.clear();
    }

    ServerConfiguredAdapter configuredAdapter(HardwareAddress chaddr) {
        return this.configuredAdapterMap.get(chaddr);
    }

    IpAddress ipAddress() {
        return this.ipAddress;
    }

    void lock() {
    }

    int port() {
        return this.port;
    }
}

