/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.rio.dhcp;

import br.com.objectos.core.util.ImmutableList;
import br.com.objectos.rio.dhcp.DhcpServer;
import br.com.objectos.rio.dhcp.DhcpServerBuilderDsl;
import br.com.objectos.rio.dhcp.DhcpServerConfiguration;
import br.com.objectos.rio.dhcp.DhcpServerListener;
import br.com.objectos.rio.dhcp.Host;
import br.com.objectos.rio.dhcp.LocalhostDhcpServer;
import br.com.objectos.rio.dhcp.NetworkAdapterDhcpServer;
import br.com.objectos.rio.dhcp.ServerConfiguredAdapter;
import br.com.objectos.rio.net.ConfiguredNetworkAdapter;
import br.com.objectos.rio.net.HardwareAddress;
import br.com.objectos.rio.net.IpAddress;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DhcpServerBuilder {
    private final ImmutableList.Builder<Host> hostList = ImmutableList.builder();
    private final ImmutableList.Builder<DhcpServerListener> listenerList = ImmutableList.builder();
    ConfiguredNetworkAdapter adapter;
    private IpAddress ipAddress;
    private int port;

    public DhcpServerBuilderDsl bindTo(ConfiguredNetworkAdapter adapter) {
        return this.bindTo(adapter, 67);
    }

    public DhcpServerBuilderDsl bindTo(ConfiguredNetworkAdapter adapter, int port) {
        this.adapter = Objects.requireNonNull(adapter);
        this.ipAddress = adapter.ipAddress();
        this.port = port;
        return new NetworkAdapterDsl();
    }

    public DhcpServerBuilderDsl localhost(int port) {
        this.port = port;
        this.ipAddress = IpAddress.localhost();
        return new LocalhostDsl();
    }

    DhcpServerConfiguration configuration() {
        return new DhcpServerConfiguration(this.ipAddress, this.port, this.configuredAdapterMap());
    }

    List<DhcpServerListener> listenerList() {
        return this.listenerList.build();
    }

    private Map<HardwareAddress, ServerConfiguredAdapter> configuredAdapterMap() {
        return this.hostList.build().stream().map(host -> host.toConfiguredAdapter(this.ipAddress)).collect(Collectors.toMap(ServerConfiguredAdapter::hardwareAddress, Function.identity(), DhcpServerBuilder.throwingMerger(), LinkedHashMap::new));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private abstract class Dsl
    implements DhcpServerBuilderDsl,
    DhcpServerBuilderDsl.AddHost,
    DhcpServerBuilderDsl.WithListener {
        private Dsl() {
        }

        @Override
        public DhcpServerBuilderDsl.AddHost addHost(Host host) {
            DhcpServerBuilder.this.hostList.add((Object)host);
            return this;
        }

        @Override
        public final DhcpServerBuilderDsl.WithListener withListener(DhcpServerListener listener) {
            DhcpServerBuilder.this.listenerList.add((Object)listener);
            return this;
        }
    }

    private class NetworkAdapterDsl
    extends Dsl {
        private NetworkAdapterDsl() {
        }

        @Override
        public DhcpServer build() {
            return new NetworkAdapterDhcpServer(DhcpServerBuilder.this);
        }
    }

    private class LocalhostDsl
    extends Dsl {
        private LocalhostDsl() {
        }

        @Override
        public DhcpServer build() {
            return new LocalhostDhcpServer(DhcpServerBuilder.this);
        }
    }
}

