/*
 * Copyright 2016 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.dhcp;

import br.com.objectos.rio.net.HardwareAddress;
import br.com.objectos.rio.net.IpAddress;
import br.com.objectos.rio.net.NetInteger;
import br.com.objectos.way.pojo.Pojo;
import br.com.objectos.way.testable.Equality;
import br.com.objectos.way.testable.Testable;
import br.com.objectos.way.testable.Tester;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
@Pojo
abstract class ServerConfiguredAdapter extends ConfiguredAdapter implements Testable {

  private static final Tester<ConfiguredAdapter> ___TESTER___ = Tester.of(ConfiguredAdapter.class)
      .add("hardwareAddress", o -> o.hardwareAddress())
      .add("domainNameServer", o -> o.domainNameServer())
      .add("ipAddress", o -> o.ipAddress())
      .add("leaseTime", o -> o.leaseTime())
      .add("subnetMask", o -> o.subnetMask())
      .add("router", o -> o.router())
      .add("serverId", o -> o.serverId())
      .build();

  public abstract Host host();
  @Override
  public abstract IpAddress serverId();

  ServerConfiguredAdapter() {
  }

  static ServerConfiguredAdapterBuilder builder() {
    return new ServerConfiguredAdapterBuilderPojo();
  }

  @Override
  public Equality isEqualTo(Object that) {
    return ___TESTER___.test(this, that);
  }

  @Override
  public String bootfileName() {
    return group().bootfileName();
  }

  @Override
  public IpAddress.Array domainNameServer() {
    return IpAddress.Array.of(IpAddress.of(8, 8, 8, 8), IpAddress.of(8, 8, 4, 4));
  }

  @Override
  public HardwareAddress hardwareAddress() {
    return host().hwAddress();
  }

  @Override
  public String hostname() {
    return host().name();
  }

  @Override
  public IpAddress ipAddress() {
    return host().ipAddress();
  }

  @Override
  public NetInteger leaseTime() {
    return NetInteger.of(86400);
  }

  @Override
  public IpAddress.Array router() {
    return IpAddress.Array.of(serverId());
  }

  @Override
  public IpAddress subnetMask() {
    return IpAddress.of(255, 255, 255, 0);
  }

  @Override
  public String tftpServerName() {
    return group().tftpServerName();
  }

  private Group group() {
    return host().group();
  }

}