/*
 * Copyright 2016 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.dhcp;

import br.com.objectos.rio.udp.Service;
import br.com.objectos.rio.udp.UdpException;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class LocalhostDhcpServer extends DhcpServer {

  public LocalhostDhcpServer(DhcpServerBuilder builder) {
    super(builder);
  }

  @Override
  protected Service service() throws UdpException {
    return Service.builder()
        .forClass(getClass())
        .bindTo(port())
        .addIncomingPacketAction(this)
        .build();
  }

}