/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.iro;

import br.com.objectos.rio.RioDirs;
import br.com.objectos.rio.RioEtcModule;

import com.google.inject.Stage;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class IroEtcModule extends RioEtcModule {

  public IroEtcModule(Stage stage) {
    super(stage);
  }

  @Override
  protected void configureMore(RioDirs rioDirs) {
    IroDirs etoDirs = new IroDirs(rioDirs);
    bind(IroDirs.class).toInstance(etoDirs);
  }

}