/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.iro;

import br.com.objectos.rio.RioDirs;
import br.com.objectos.way.base.io.Directory;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class IroDirs {

  private final Directory iroVar;

  private final Directory etoVar;
  private final Directory etoMountDir;

  private final Directory userSettings;

  public IroDirs(RioDirs rioDirs) {
    Directory userVar = rioDirs.userVar();
    iroVar = userVar.dirAt("iro");
    etoVar = iroVar.dirAt("eto");
    etoMountDir = etoVar.dirAt("gentoo");

    Directory userSettings = rioDirs.userSettings();
    this.userSettings = userSettings.dirAt("iro");
  }

  public Directory iroVar() {
    return iroVar;
  }

  public Directory etoVar() {
    return etoVar;
  }

  public Directory etoMountDir() {
    return etoMountDir;
  }

  public Directory userSettings() {
    return userSettings;
  }

}