/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.iro;

import br.com.objectos.rio.AbstractRioCommand;
import br.com.objectos.rio.Gentoo;
import br.com.objectos.rio.GentooInstaller;

import com.google.inject.Inject;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class DisklessEtoPrepare extends AbstractRioCommand<DisklessEtoPrepareOptions> {

  private final IroDirs dirs;

  private final Gentoo gentoo;

  @Inject
  public DisklessEtoPrepare(IroDirs dirs, Gentoo gentoo) {
    this.dirs = dirs;
    this.gentoo = gentoo;
  }

  @Override
  protected String getCommandName() {
    return "iro diskless eto prepare";
  }

  @Override
  protected DisklessEtoPrepareOptions newOptions() {
    return new DisklessEtoPrepareOptions();
  }

  @Override
  protected void executeCommand(DisklessEtoPrepareOptions options) {
    GentooInstaller installer = gentoo.installer(this)
        .tempDirAt(dirs.etoVar())
        .mountDirAt(dirs.etoMountDir())
        .stageServer(options.fileServer())
        .distfilesServer(options.distfilesServer())
        .resourcesAt("/diskless/eto")
        .resourcesListAt("/diskless/eto-files.txt")
        .resourcesMapAt("/diskless/eto-maps.txt")
        .resourcesContext(options)
        .setProfileTo(4)
        .kernelVersion("3.10.17")

        .symlink("/etc/init.d/net.lo").to("/etc/init.d/net.eth0")

        .chmod()
        /**/.file("/etc/local.d/00-iro-eto-ssh-key.start").to(755)
        .done()

        .useradd().home("/iro").gid("users").groups("wheel").shell("/bin/bash").login("iro")

        .rcUpdate()
        /**/.add("net.eth0").toDefault()
        /**/.add("sshd").toDefault()
        /**/.add("syslog-ng").toDefault()
        .done()

        .withPxe()

        .build();

    if (options.all()) {

    }

    if (options.stage) {
      installer.stage();
    }

    if (options.objectos) {
      installer.objectos();
    }

    if (options.ekernel) {
      installer.ekernel();
    }

    if (options.eworld) {
      installer.eworld();
    }

    if (options.initramfs) {
      installer.initramfs();
    }

    if (options.grub) {
      installer.grub();
    }

    if (options.rio) {
      installer.rio();
    }

    installer.symlink();
    installer.chmod();
    installer.useradd();
    installer.rcUpdate();
  }

}