/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.testing.fs;

import br.com.objectos.collections.list.MutableList;
import br.com.objectos.core.runtime.ShutdownHook;
import br.com.objectos.core.runtime.ShutdownHookTask;
import br.com.objectos.core.throwable.Throwables;
import br.com.objectos.fs.Directory;
import br.com.objectos.fs.JavaIoTmpdir;
import br.com.objectos.testing.random.TestingRandom;
import java.io.IOException;

final class TempDirectories
implements ShutdownHookTask {
    static final TempDirectories INSTANCE = TempDirectories.create();
    private final MutableList<Directory> directories = MutableList.create();

    private TempDirectories() {
    }

    private static TempDirectories create() {
        TempDirectories instance = new TempDirectories();
        ShutdownHook.register((ShutdownHookTask)instance);
        return instance;
    }

    public final void executeShutdownHookTask() throws Exception {
        Throwable rethrow = null;
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            Directory directory = (Directory)this.directories.get(i);
            try {
                directory.deleteContents();
            }
            catch (Exception e) {
                rethrow = Throwables.addSuppressed(rethrow, (Throwable)e);
            }
            try {
                directory.delete();
                continue;
            }
            catch (Exception e) {
                rethrow = Throwables.addSuppressed((Throwable)rethrow, (Throwable)e);
            }
        }
        if (rethrow != null) {
            throw (Exception)rethrow;
        }
    }

    public final Directory next() throws IOException {
        Directory tempDirectory = JavaIoTmpdir.get();
        String suffix = TestingRandom.nextString((int)10);
        Directory result = tempDirectory.createDirectory("objectos-testing-fs-" + suffix);
        this.directories.add((Object)result);
        return result;
    }
}

