/*
 * Copyright (C) 2011-2022 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.testing.fs;

import br.com.objectos.collections.list.MutableList;
import br.com.objectos.core.runtime.ShutdownHook;
import br.com.objectos.core.runtime.ShutdownHookTask;
import br.com.objectos.core.throwable.Throwables;
import br.com.objectos.fs.Directory;
import br.com.objectos.fs.JavaIoTmpdir;
import br.com.objectos.testing.random.TestingRandom;
import java.io.IOException;

final class TempDirectories implements ShutdownHookTask {

  static final TempDirectories INSTANCE = create();

  private final MutableList<Directory> directories = MutableList.create();

  private TempDirectories() {}

  private static TempDirectories create() {
    TempDirectories instance;
    instance = new TempDirectories();

    ShutdownHook.register(instance);

    return instance;
  }

  @Override
  public final void executeShutdownHookTask() throws Exception {
    Throwable rethrow;
    rethrow = null;

    for (int i = 0, size = directories.size(); i < size; i++) {
      Directory directory;
      directory = directories.get(i);

      try {
        directory.deleteContents();
      } catch (Exception e) {
        rethrow = Throwables.addSuppressed(rethrow, e);
      }

      try {
        directory.delete();
      } catch (Exception e) {
        rethrow = Throwables.addSuppressed(rethrow, e);
      }
    }

    if (rethrow != null) {
      throw (Exception) rethrow;
    }
  }

  public final Directory next() throws IOException {
    Directory tempDirectory;
    tempDirectory = JavaIoTmpdir.get();

    String suffix;
    suffix = TestingRandom.nextString(10);

    Directory result;
    result = tempDirectory.createDirectory("objectos-testing-fs-" + suffix);

    directories.add(result);

    return result;
  }

}