/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSEBDeploymentBuilder;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSEBDeploymentConfig;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.SlaveDeployerCallable;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Utils;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerContext;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class DeployerRunner {
    private final Run<?, ?> build;
    private final Launcher launcher;
    private final TaskListener listener;
    private final FilePath workspace;
    private final AWSEBDeploymentConfig config;

    DeployerRunner(Run<?, ?> build, FilePath ws, Launcher launcher, TaskListener listener, AWSEBDeploymentBuilder deploymentBuilder) throws InterruptedException, MacroEvaluationException, IOException {
        this.build = build;
        this.launcher = launcher;
        this.listener = listener;
        this.workspace = ws;
        this.config = deploymentBuilder.getConfig().replacedCopy(new Utils.Replacer(build, this.workspace, listener));
    }

    public boolean perform() throws Exception {
        FilePath rootFileObject = new FilePath(this.workspace, this.config.getRootObject());
        DeployerContext deployerContext = new DeployerContext(this.config, rootFileObject, this.listener);
        VirtualChannel channel = this.launcher.getChannel();
        if (null == channel) {
            throw new IllegalStateException("Null Channel (?)");
        }
        Future booleanFuture = channel.callAsync((Callable)new SlaveDeployerCallable(deployerContext));
        return (Boolean)booleanFuture.get();
    }
}

