/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSClientFactory;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSEBDeploymentConfig;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.DeployerRunner;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Utils;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.s3.AmazonS3Client;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSEBDeploymentBuilder
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(AWSEBDeploymentBuilder.class);
    private AWSEBDeploymentConfig config;

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return super.perform(build, launcher, listener);
    }

    @DataBoundConstructor
    public AWSEBDeploymentBuilder(AWSEBDeploymentConfig config) {
        if (null == config) {
            config = new AWSEBDeploymentConfig();
        }
        this.config = config;
    }

    @DataBoundSetter
    public void setSkipEnvironmentUpdates(boolean skipEnvironmentUpdates) {
        this.config.setSkipEnvironmentUpdates(skipEnvironmentUpdates);
    }

    @DataBoundSetter
    public void setMaxAttempts(Integer maxAttempts) {
        this.config.setMaxAttempts(maxAttempts);
    }

    @DataBoundSetter
    public void setCheckHealth(boolean checkHealth) {
        this.config.setCheckHealth(checkHealth);
    }

    @DataBoundSetter
    public void setSleepTime(Integer sleepTime) {
        this.config.setSleepTime(sleepTime);
    }

    @DataBoundSetter
    public void setZeroDowntime(boolean zeroDowntime) {
        this.config.setZeroDowntime(zeroDowntime);
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.config.setExcludes(excludes);
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.config.setIncludes(includes);
    }

    @DataBoundSetter
    public void setRootObject(String rootObject) {
        this.config.setRootObject(rootObject);
    }

    @DataBoundSetter
    public void setVersionDescriptionFormat(String versionDescriptionFormat) {
        this.config.setVersionDescriptionFormat(versionDescriptionFormat);
    }

    @DataBoundSetter
    public void setVersionLabelFormat(String versionLabelFormat) {
        this.config.setVersionLabelFormat(versionLabelFormat);
    }

    @DataBoundSetter
    public void setKeyPrefix(String keyPrefix) {
        this.config.setKeyPrefix(keyPrefix);
    }

    @DataBoundSetter
    public void setBucketName(String bucketName) {
        this.config.setBucketName(bucketName);
    }

    @DataBoundSetter
    public void setEnvironmentName(String environmentName) {
        this.config.setEnvironmentName(environmentName);
    }

    @DataBoundSetter
    public void setApplicationName(String applicationName) {
        this.config.setApplicationName(applicationName);
    }

    @DataBoundSetter
    public void setAwsRegion(String awsRegion) {
        this.config.setAwsRegion(awsRegion);
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.config.setCredentialId(credentialId);
    }

    public boolean isSkipEnvironmentUpdates() {
        return this.config.isSkipEnvironmentUpdates();
    }

    public Integer getMaxAttempts() {
        return this.config.getMaxAttempts();
    }

    public boolean isCheckHealth() {
        return this.config.isCheckHealth();
    }

    public Integer getSleepTime() {
        return this.config.getSleepTime();
    }

    public boolean isZeroDowntime() {
        return this.config.isZeroDowntime();
    }

    public String getExcludes() {
        return this.config.getExcludes();
    }

    public String getIncludes() {
        return this.config.getIncludes();
    }

    public String getRootObject() {
        return this.config.getRootObject();
    }

    public String getVersionDescriptionFormat() {
        return this.config.getVersionDescriptionFormat();
    }

    public String getVersionLabelFormat() {
        return this.config.getVersionLabelFormat();
    }

    public String getKeyPrefix() {
        return this.config.getKeyPrefix();
    }

    public String getBucketName() {
        return this.config.getBucketName();
    }

    public String getEnvironmentName() {
        return this.config.getEnvironmentName();
    }

    public String getApplicationName() {
        return this.config.getApplicationName();
    }

    public String getAwsRegion() {
        return this.config.getAwsRegion();
    }

    public String getCredentialId() {
        return this.config.getCredentialId();
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath ws, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException {
        try {
            new DeployerRunner(build, ws, launcher, listener, this).perform();
        }
        catch (Exception exc) {
            throw new IOException("Deployment Failure", exc);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public AWSEBDeploymentConfig getConfig() {
        return this.config;
    }

    public static class AWSCredentialsListBoxModel
    extends AbstractIdCredentialsListBoxModel<AWSCredentialsListBoxModel, AmazonWebServicesCredentials> {
        @NonNull
        protected String describe(@NonNull AmazonWebServicesCredentials c) {
            return CredentialsNameProvider.name((Credentials)c);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "AWS Elastic Beanstalk";
        }

        public AbstractIdCredentialsListBoxModel<?, ?> doFillCredentialIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new AWSCredentialsListBoxModel();
            }
            List creds = CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList());
            return new AWSCredentialsListBoxModel().withEmptySelection().withAll((Iterable)creds);
        }

        public FormValidation doCheckAwsRegion(@QueryParameter String value) {
            if (value.contains("$")) {
                return FormValidation.warning((String)"Validation skipped due to parameter usage ('$')");
            }
            if (!value.matches("^\\p{Alpha}{2}-(?:gov-)?\\p{Alpha}{4,}-\\d$")) {
                return FormValidation.error((String)"Doesn't look like a region, like {place}-{cardinal}-{number}");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApplicationName(@QueryParameter String value) {
            if (value.contains("$")) {
                return FormValidation.warning((String)"Validation skipped due to parameter usage ('$')");
            }
            int valueLen = value.length();
            if (valueLen == 0 || valueLen > 100) {
                return FormValidation.error((String)"Application Names must have between 1-100 characters");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvironmentName(@QueryParameter String value, @QueryParameter boolean skipEnvironmentUpdates) {
            if (skipEnvironmentUpdates) {
                return FormValidation.ok((String)"Environment Updates Skipped");
            }
            if (value.contains("$")) {
                return FormValidation.warning((String)"Validation skipped due to parameter usage ('$')");
            }
            if (value.contains(",")) {
                if (!value.matches("^[\\p{Alpha}[\\p{Alnum}\\-]{0,39}]+(,\\p{Space}*[\\p{Alpha}[\\p{Alnum}\\-]{0,39}]+)*$") || value.endsWith("-")) {
                    return FormValidation.error((String)"Doesn't look like properly comma separated environment names. Each must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It cannot start or end with a hyphen");
                }
            } else if (!value.matches("^\\p{Alpha}[\\p{Alnum}\\-]{0,39}$") || value.endsWith("-")) {
                return FormValidation.error((String)"Doesn't look like an environment name. Must be from 4 to 40 characters in length. The name can contain only letters, numbers, and hyphens. It cannot start or end with a hyphen");
            }
            return FormValidation.ok();
        }

        public FormValidation doValidateCredentials(@QueryParameter(value="credentialId") String credentialId, @QueryParameter String awsRegion) {
            for (String value : Arrays.asList(credentialId, awsRegion)) {
                if (!value.contains("$")) continue;
                return FormValidation.warning((String)"Validation skipped due to parameter usage ('$')");
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter w = new PrintWriter((Writer)stringWriter, true);
            try {
                w.printf("<ul>%n", new Object[0]);
                w.printf("<li>Building Client (credentialId: '%s', region: '%s')</li>%n", Util.escape((String)credentialId), Util.escape((String)awsRegion));
                AWSClientFactory factory = AWSClientFactory.getClientFactory(credentialId, awsRegion);
                AmazonS3Client amazonS3 = factory.getService(AmazonS3Client.class);
                String s3Endpoint = factory.getEndpointFor(amazonS3);
                w.printf("<li>Testing Amazon S3 Service (endpoint: %s)</li>%n", Util.escape((String)s3Endpoint));
                w.printf("<li>Buckets Found: %d</li>%n", amazonS3.listBuckets().size());
                AWSElasticBeanstalkClient awsElasticBeanstalk = factory.getService(AWSElasticBeanstalkClient.class);
                String awsEBEndpoint = factory.getEndpointFor(awsElasticBeanstalk);
                w.printf("<li>Testing AWS Elastic Beanstalk Service (endpoint: %s)</li>%n", Util.escape((String)awsEBEndpoint));
                List applicationList = Lists.transform((List)awsElasticBeanstalk.describeApplications().getApplications(), (Function)new Function<ApplicationDescription, String>(){

                    public String apply(ApplicationDescription input) {
                        return input.getApplicationName();
                    }
                });
                w.printf("<li>Applications Found: %d (%s)</li>%n", applicationList.size(), Util.escape((String)StringUtils.join((Collection)applicationList, (String)", ")));
                w.printf("</ul>%n", new Object[0]);
                return FormValidation.okWithMarkup((String)stringWriter.toString());
            }
            catch (Exception exc) {
                return FormValidation.error((Throwable)exc, (String)"Failure");
            }
        }

        public FormValidation doValidateCoordinates(@QueryParameter(value="credentialId") String credentialId, @QueryParameter(value="awsRegion") String awsRegion, @QueryParameter(value="applicationName") String applicationName, @QueryParameter(value="environmentName") String environmentName, @QueryParameter(value="skipEnvironmentUpdates") boolean skipEnvironmentUpdates) throws Exception {
            if (skipEnvironmentUpdates) {
                return FormValidation.ok((String)"Skipping Environment Updates");
            }
            for (String value : Arrays.asList(credentialId, awsRegion, applicationName, environmentName)) {
                if (!value.contains("$")) continue;
                return FormValidation.warning((String)"Validation skipped due to parameter usage ('$')");
            }
            ArrayList environmentNames = Lists.newArrayList((Object[])environmentName.replaceAll("\\s", "").split(","));
            AWSClientFactory clientFactory = AWSClientFactory.getClientFactory(credentialId, awsRegion);
            AWSElasticBeanstalk awsElasticBeanstalk = (AWSElasticBeanstalk)clientFactory.getService(AWSElasticBeanstalkClient.class);
            DescribeEnvironmentsResult describeEnvironmentsResult = awsElasticBeanstalk.describeEnvironments(new DescribeEnvironmentsRequest().withApplicationName(applicationName).withIncludeDeleted(Boolean.valueOf(false)).withEnvironmentNames((Collection)environmentNames));
            if (describeEnvironmentsResult.getEnvironments().size() > 1) {
                ArrayList environmentIds = Lists.newArrayList();
                Integer size = describeEnvironmentsResult.getEnvironments().size();
                Integer i = 0;
                while (i < size) {
                    environmentIds.add(((EnvironmentDescription)describeEnvironmentsResult.getEnvironments().get(i)).getEnvironmentId());
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                return FormValidation.ok((String)"Multiple environments found (environmentIDs: %s)", (Object[])new Object[]{StringUtils.join((Collection)environmentIds, (String)", ")});
            }
            if (describeEnvironmentsResult.getEnvironments().size() == 1) {
                String environmentId = ((EnvironmentDescription)describeEnvironmentsResult.getEnvironments().get(0)).getEnvironmentId();
                return FormValidation.ok((String)"Environment found (environmentId: %s)", (Object[])new Object[]{environmentId});
            }
            return FormValidation.error((String)"Environment not found");
        }

        public FormValidation doValidateUpload(@QueryParameter(value="applicationName") String applicationName, @QueryParameter(value="bucketName") String bucketName, @QueryParameter(value="keyPrefix") String keyPrefix, @QueryParameter(value="versionLabelFormat") String versionLabelFormat) {
            String objectKey = Utils.formatPath("%s/%s-%s.zip", StringUtils.defaultIfBlank((String)keyPrefix, (String)"<ERROR: MISSING KEY PREFIX>"), StringUtils.defaultIfBlank((String)applicationName, (String)"<ERROR: MISSING APPLICATION NAME>"), StringUtils.defaultIfBlank((String)versionLabelFormat, (String)"<ERROR: MISSING VERSION LABEL FORMAT>"));
            String targetPath = Util.escape((String)String.format("s3://%s/%s", StringUtils.defaultIfBlank((String)bucketName, (String)"[default account bucket for region]"), objectKey));
            String resultingMessage = String.format("Your object will be uploaded to S3 as: <code>%s</code> (<i>note replacements will apply</i>)", targetPath);
            return FormValidation.okWithMarkup((String)resultingMessage);
        }
    }
}

