/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.Constants;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Utils;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.s3.AmazonS3;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.security.auth.login.CredentialNotFoundException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.apache.commons.lang.reflect.FieldUtils;

public class AWSClientFactory
implements Constants {
    private AWSCredentialsProvider provider;
    private ClientConfiguration clientConfiguration;
    private String region;

    private AWSClientFactory(AWSCredentialsProvider provider, ClientConfiguration clientConfiguration, String region) {
        this.provider = provider;
        this.clientConfiguration = clientConfiguration;
        this.region = region.toLowerCase();
    }

    private static AWSClientFactory getClientFactory(AWSCredentialsProvider provider, String awsRegion) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        Jenkins jenkins = Jenkins.get();
        if (jenkins.proxy != null) {
            ProxyConfiguration proxyConfig = jenkins.proxy;
            clientConfig.setProxyHost(proxyConfig.name);
            clientConfig.setProxyPort(proxyConfig.port);
            if (proxyConfig.getUserName() != null) {
                clientConfig.setProxyUsername(proxyConfig.getUserName());
                clientConfig.setProxyPassword(proxyConfig.getPassword());
            }
        }
        clientConfig.setUserAgentPrefix("ingenieux CloudButler/" + Utils.getVersion());
        return new AWSClientFactory(provider, clientConfig, awsRegion);
    }

    public static AWSClientFactory getClientFactory(String credentialsId, String awsRegion) throws CredentialNotFoundException {
        DefaultAWSCredentialsProviderChain provider = new DefaultAWSCredentialsProviderChain();
        if (StringUtils.isNotBlank((String)credentialsId)) {
            provider = AWSClientFactory.lookupNamedCredential(credentialsId);
        }
        return AWSClientFactory.getClientFactory((AWSCredentialsProvider)provider, awsRegion);
    }

    private static AmazonWebServicesCredentials lookupNamedCredential(String credentialsId) throws CredentialNotFoundException {
        List credentialList = CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        AmazonWebServicesCredentials cred = (AmazonWebServicesCredentials)CredentialsMatchers.firstOrNull((Iterable)credentialList, (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId)}));
        if (cred == null) {
            throw new CredentialNotFoundException(credentialsId);
        }
        return cred;
    }

    public <T> T getService(Class<T> serviceClazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class[] paramTypes = new Class[]{AWSCredentialsProvider.class, ClientConfiguration.class};
        ClientConfiguration newClientConfiguration = new ClientConfiguration(this.clientConfiguration);
        newClientConfiguration = AmazonS3.class.isAssignableFrom(serviceClazz) ? newClientConfiguration.withSignerOverride("AWSS3V4SignerType") : newClientConfiguration.withSignerOverride(null);
        Object[] params = new Object[]{this.provider, newClientConfiguration};
        Object resultObj = ConstructorUtils.invokeConstructor(serviceClazz, (Object[])params, (Class[])paramTypes);
        if ("us-east-1".equals(StringUtils.defaultString((String)this.region, (String)"us-east-1"))) {
            return (T)resultObj;
        }
        for (ServiceEndpointFormatter formatter : ServiceEndpointFormatter.values()) {
            if (!formatter.matches(resultObj)) continue;
            ((AmazonWebServiceClient)resultObj).setEndpoint(this.getEndpointFor(formatter));
            break;
        }
        return (T)resultObj;
    }

    private String getEndpointFor(ServiceEndpointFormatter formatter) {
        String endpointStr = String.format(formatter.serviceMask, this.region);
        if (this.region.startsWith("cn-") && (endpointStr = endpointStr + ".cn").matches("s3-cn-\\p{Alpha}+-\\d.amazonaws.com.cn")) {
            endpointStr = endpointStr.replaceFirst("s3-cn-", "s3.cn-");
        }
        return endpointStr;
    }

    <T extends AmazonWebServiceClient> String getEndpointFor(T client) {
        try {
            URI endpointUri = (URI)FieldUtils.readField(client, (String)"endpoint", (boolean)true);
            return endpointUri.toASCIIString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static enum ServiceEndpointFormatter {
        ELASTICBEANSTALK(AWSElasticBeanstalk.class, "elasticbeanstalk.%s.amazonaws.com"),
        S3(AmazonS3.class, "s3-%s.amazonaws.com");

        final Class<?> serviceClass;
        final String serviceMask;

        private ServiceEndpointFormatter(Class<?> serviceClass, String serviceMask) {
            this.serviceClass = serviceClass;
            this.serviceMask = serviceMask;
        }

        public boolean matches(Object obj) {
            return this.serviceClass.isAssignableFrom(obj.getClass());
        }
    }
}

