/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.Constants;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class Utils
implements Constants {
    private static String VERSION = "UNKNOWN";

    public static String formatPath(String mask, Object ... args) {
        return Utils.strip(String.format(mask, args).replaceAll("(\\/{2,})", "/"));
    }

    private static String strip(String str) {
        return StringUtils.strip((String)str, (String)"/ ");
    }

    public static String getVersion() {
        if ("UNKNOWN".equals(VERSION)) {
            try (InputStream is = Utils.class.getResourceAsStream("version.properties");){
                Properties p = new Properties();
                p.load(is);
                VERSION = p.getProperty("awseb-deployer-plugin.version");
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
        return VERSION;
    }

    public static class Replacer {
        Run<?, ?> build;
        TaskListener listener;
        FilePath workspace;

        public Replacer(Run<?, ?> build, FilePath workspace, TaskListener listener) {
            this.build = build;
            this.listener = listener;
            this.workspace = workspace;
        }

        public String r(String value) throws MacroEvaluationException, IOException, InterruptedException {
            return Utils.strip(TokenMacro.expandAll(this.build, (FilePath)this.workspace, (TaskListener)this.listener, (String)value));
        }
    }
}

