/*
 * Decompiled with CFR 0.152.
 */
package br.com.braspag.silentorderpost.network;

import br.com.braspag.silentorderpost.extensions.HttpStatusCode;
import br.com.braspag.silentorderpost.extensions.HttpStatusCodeKt;
import br.com.braspag.silentorderpost.models.AccessTokenResponse;
import br.com.braspag.silentorderpost.models.AccessTokenResult;
import br.com.braspag.silentorderpost.models.ErrorResponse;
import br.com.braspag.silentorderpost.models.SilentOrderPostEnvironment;
import br.com.braspag.silentorderpost.models.SilentOrderPostRequest;
import br.com.braspag.silentorderpost.models.SilentOrderPostResponse;
import br.com.braspag.silentorderpost.models.SilentOrderPostResult;
import br.com.braspag.silentorderpost.models.ValidationResponse;
import br.com.braspag.silentorderpost.network.SilentOrderPostApi;
import br.com.braspag.silentorderpost.network.WebClient;
import com.google.gson.Gson;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\u0007\u001a\u00020\b2'\u0010\t\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J^\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172'\u0010\t\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lbr/com/braspag/silentorderpost/network/SilentOrderPostClient;", "", "merchantId", "", "environment", "Lbr/com/braspag/silentorderpost/models/SilentOrderPostEnvironment;", "(Ljava/lang/String;Lbr/com/braspag/silentorderpost/models/SilentOrderPostEnvironment;)V", "getAccessToken", "", "callback", "Lkotlin/Function1;", "Lbr/com/braspag/silentorderpost/models/AccessTokenResult;", "Lbr/com/braspag/silentorderpost/models/AccessTokenResponse;", "Lkotlin/ParameterName;", "name", "model", "getAccessToken$silentorderpost_release", "getEnvironmentUrl", "sendCardData", "accessToken", "request", "Lbr/com/braspag/silentorderpost/models/SilentOrderPostRequest;", "binQuery", "", "verifyCard", "tokenize", "Lbr/com/braspag/silentorderpost/models/SilentOrderPostResult;", "Lbr/com/braspag/silentorderpost/models/SilentOrderPostResponse;", "sendCardData$silentorderpost_release", "silentorderpost_release"})
public final class SilentOrderPostClient {
    private final String merchantId;
    private final SilentOrderPostEnvironment environment;

    public final void getAccessToken$silentorderpost_release(@NotNull Function1<? super AccessTokenResult<AccessTokenResponse>, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        WebClient webClient = new WebClient(this.getEnvironmentUrl(this.environment));
        Call call = SilentOrderPostApi.DefaultImpls.getAccessToken$default(webClient.createService(SilentOrderPostApi.class), this.merchantId, null, null, 6, null);
        call.enqueue((Callback)new Callback<AccessTokenResponse>(callback){
            final /* synthetic */ Function1 $callback;

            public void onFailure(@NotNull Call<AccessTokenResponse> call, @NotNull Throwable t) {
                block1: {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    String string = t.getLocalizedMessage();
                    if (string == null) break block1;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    String string3 = t.getLocalizedMessage();
                    if (string3 == null) {
                        string3 = "Unknown Error";
                    }
                    this.$callback.invoke(new AccessTokenResult<Object>(null, HttpStatusCode.Unknown, CollectionsKt.listOf((Object)new ErrorResponse(string3))));
                }
            }

            public void onResponse(@NotNull Call<AccessTokenResponse> call, @NotNull Response<AccessTokenResponse> response) {
                block1: {
                    boolean bl;
                    block0: {
                        Intrinsics.checkParameterIsNotNull(call, (String)"call");
                        Intrinsics.checkParameterIsNotNull(response, (String)"response");
                        bl = response.isSuccessful();
                        if (!bl) break block0;
                        this.$callback.invoke(new AccessTokenResult<T>(response.body(), HttpStatusCodeKt.toStatusCode(response.code()), null, 4, null));
                        break block1;
                    }
                    if (bl) break block1;
                    HttpStatusCode httpStatusCode = HttpStatusCodeKt.toStatusCode(response.code());
                    String string = Intrinsics.areEqual((Object)response.message(), (Object)"") ^ true ? response.message() : "Unknown error";
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (response.message() !\u2026ge() else \"Unknown error\"");
                    this.$callback.invoke(new AccessTokenResult<Object>(null, httpStatusCode, CollectionsKt.listOf((Object)new ErrorResponse(string))));
                }
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void sendCardData$silentorderpost_release(@NotNull String accessToken, @NotNull SilentOrderPostRequest request, boolean binQuery, boolean verifyCard, boolean tokenize, @NotNull Function1<? super SilentOrderPostResult<SilentOrderPostResponse>, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        WebClient webClient = new WebClient(this.getEnvironmentUrl(this.environment));
        Call call = SilentOrderPostApi.DefaultImpls.sendCardData$default(webClient.createService(SilentOrderPostApi.class), accessToken, request.getCardHolder(), request.getCardNumber(), request.getCardExpirationDate(), request.getCardSecurityCode(), binQuery, verifyCard, tokenize, null, null, null, 1792, null);
        call.enqueue((Callback)new Callback<SilentOrderPostResponse>(callback){
            final /* synthetic */ Function1 $callback;

            public void onFailure(@NotNull Call<SilentOrderPostResponse> call, @NotNull Throwable t) {
                block0: {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    String string = t.getLocalizedMessage();
                    if (string == null) break block0;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    this.$callback.invoke(new SilentOrderPostResult<SilentOrderPostResponse>(null, HttpStatusCode.Unknown, null, null, 8, null));
                }
            }

            public void onResponse(@NotNull Call<SilentOrderPostResponse> call, @NotNull Response<SilentOrderPostResponse> response) {
                block5: {
                    boolean bl;
                    block4: {
                        Intrinsics.checkParameterIsNotNull(call, (String)"call");
                        Intrinsics.checkParameterIsNotNull(response, (String)"response");
                        bl = response.isSuccessful();
                        if (!bl) break block4;
                        this.$callback.invoke(new SilentOrderPostResult<SilentOrderPostResponse>(response.body(), HttpStatusCodeKt.toStatusCode(response.code()), null, null, 12, null));
                        break block5;
                    }
                    if (bl) break block5;
                    ResponseBody responseBody = response.errorBody();
                    String errorBody = responseBody != null ? responseBody.string() : null;
                    List errors = null;
                    ValidationResponse validations = null;
                    try {
                        Object object = new Gson().fromJson(errorBody, ErrorResponse[].class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(\n       \u2026                        )");
                        errors = ArraysKt.toList((Object[])((Object[])object));
                    }
                    catch (Exception ex) {
                        errors = null;
                    }
                    try {
                        validations = (ValidationResponse)new Gson().fromJson(errorBody, ValidationResponse.class);
                    }
                    catch (Exception ex) {
                        validations = null;
                    }
                    this.$callback.invoke(new SilentOrderPostResult<Object>(null, HttpStatusCodeKt.toStatusCode(response.code()), errors, validations));
                }
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    private final String getEnvironmentUrl(SilentOrderPostEnvironment environment) {
        return environment == SilentOrderPostEnvironment.SANDBOX ? "https://transactionsandbox.pagador.com.br/post/api/public/v1/" : "https://transaction.pagador.com.br/post/api/public/v1/";
    }

    public SilentOrderPostClient(@NotNull String merchantId, @NotNull SilentOrderPostEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)merchantId, (String)"merchantId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        this.merchantId = merchantId;
        this.environment = environment;
    }

    public /* synthetic */ SilentOrderPostClient(String string, SilentOrderPostEnvironment silentOrderPostEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            silentOrderPostEnvironment = SilentOrderPostEnvironment.SANDBOX;
        }
        this(string, silentOrderPostEnvironment);
    }
}

