/*
 * Decompiled with CFR 0.152.
 */
package br.com.braspag.cieloecommerceoauth.model;

import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0017\u001a\u00020\u0014J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lbr/com/braspag/cieloecommerceoauth/model/AccessToken;", "", "token", "", "expiresIn", "", "issuedAt", "Ljava/util/Date;", "(Ljava/lang/String;ILjava/util/Date;)V", "getExpiresIn", "()I", "getIssuedAt", "()Ljava/util/Date;", "getToken", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "stillValid", "toString", "cieloecommerceoauth_release"})
public final class AccessToken {
    @NotNull
    private final String token;
    private final int expiresIn;
    @NotNull
    private final Date issuedAt;

    public final boolean stillValid() {
        long expMs;
        long issMs = this.issuedAt.getTime();
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        Date date = calendar.getTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"Calendar.getInstance().time");
        long nowMs = date.getTime();
        long l = nowMs;
        return issMs <= l && (expMs = issMs + (long)(this.expiresIn * 1000)) > l;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    public final int getExpiresIn() {
        return this.expiresIn;
    }

    @NotNull
    public final Date getIssuedAt() {
        return this.issuedAt;
    }

    public AccessToken(@NotNull String token, int expiresIn, @NotNull Date issuedAt) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)issuedAt, (String)"issuedAt");
        this.token = token;
        this.expiresIn = expiresIn;
        this.issuedAt = issuedAt;
    }

    @NotNull
    public final String component1() {
        return this.token;
    }

    public final int component2() {
        return this.expiresIn;
    }

    @NotNull
    public final Date component3() {
        return this.issuedAt;
    }

    @NotNull
    public final AccessToken copy(@NotNull String token, int expiresIn, @NotNull Date issuedAt) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)issuedAt, (String)"issuedAt");
        return new AccessToken(token, expiresIn, issuedAt);
    }

    public static /* synthetic */ AccessToken copy$default(AccessToken accessToken, String string, int n, Date date, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = accessToken.token;
        }
        if ((n2 & 2) != 0) {
            n = accessToken.expiresIn;
        }
        if ((n2 & 4) != 0) {
            date = accessToken.issuedAt;
        }
        return accessToken.copy(string, n, date);
    }

    @NotNull
    public String toString() {
        return "AccessToken(token=" + this.token + ", expiresIn=" + this.expiresIn + ", issuedAt=" + this.issuedAt + ")";
    }

    public int hashCode() {
        String string = this.token;
        Date date = this.issuedAt;
        return ((string != null ? string.hashCode() : 0) * 31 + this.expiresIn) * 31 + (date != null ? ((Object)date).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AccessToken)) break block3;
                AccessToken accessToken = (AccessToken)object;
                if (!Intrinsics.areEqual((Object)this.token, (Object)accessToken.token) || this.expiresIn != accessToken.expiresIn || !Intrinsics.areEqual((Object)this.issuedAt, (Object)accessToken.issuedAt)) break block3;
            }
            return true;
        }
        return false;
    }
}

