/*
 * Decompiled with CFR 0.152.
 */
package br.com.cielo.librarycielolinkpagamentos.network;

import br.com.cielo.librarycielolinkpagamentos.Environment;
import br.com.cielo.librarycielolinkpagamentos.extension.ExtensionKt;
import br.com.cielo.librarycielolinkpagamentos.models.LinkPagamentosApi;
import br.com.cielo.librarycielolinkpagamentos.models.Transaction;
import br.com.cielo.librarycielolinkpagamentos.network.WebClient;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\fJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lbr/com/cielo/librarycielolinkpagamentos/network/LinkPagamentosHttpClient;", "", "environment", "Lbr/com/cielo/librarycielolinkpagamentos/Environment;", "(Lbr/com/cielo/librarycielolinkpagamentos/Environment;)V", "getLink", "", "model", "Lbr/com/cielo/librarycielolinkpagamentos/models/Transaction;", "token", "", "onGetLinkCallback", "Lkotlin/Function1;", "onErrorCallback", "useSandbox", "librarycielolinkpagamentos_release"})
public final class LinkPagamentosHttpClient {
    private final Environment environment;

    public final void getLink(@NotNull Transaction model, @NotNull String token, @NotNull Function1<? super Transaction, Unit> onGetLinkCallback, @NotNull Function1<? super String, Unit> onErrorCallback) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull(onGetLinkCallback, (String)"onGetLinkCallback");
        Intrinsics.checkParameterIsNotNull(onErrorCallback, (String)"onErrorCallback");
        String authorizationFormat = ExtensionKt.addBearerFormat(token);
        String xSdkVersion = "CieloPaymentLink@1.0.2";
        WebClient webClient = new WebClient(this.useSandbox(this.environment));
        Call<Transaction> call = webClient.createService(LinkPagamentosApi.class).postTransaction(authorizationFormat, xSdkVersion, model);
        call.enqueue((Callback)new Callback<Transaction>(onErrorCallback, onGetLinkCallback){
            final /* synthetic */ Function1 $onErrorCallback;
            final /* synthetic */ Function1 $onGetLinkCallback;

            public void onFailure(@NotNull Call<Transaction> call, @NotNull Throwable t) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                this.$onErrorCallback.invoke((Object)String.valueOf(t.getMessage()));
            }

            public void onResponse(@NotNull Call<Transaction> call, @NotNull Response<Transaction> response) {
                Transaction transaction;
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                Transaction transaction2 = transaction = (Transaction)response.body();
                if (transaction2 != null) {
                    Transaction transaction3 = transaction2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Transaction it = transaction3;
                    boolean bl3 = false;
                    this.$onGetLinkCallback.invoke((Object)it);
                }
                if (transaction == null) {
                    this.$onErrorCallback.invoke((Object)("error " + response.code() + ' ' + (Object)((Object)ExtensionKt.toStatusCode(response.code()))));
                }
            }
            {
                this.$onErrorCallback = $captured_local_variable$0;
                this.$onGetLinkCallback = $captured_local_variable$1;
            }
        });
    }

    private final String useSandbox(Environment environment) {
        return environment == Environment.SANDBOX ? "https://meucheckoutsandbox.braspag.com.br/api/public/" : "https://cieloecommerce.cielo.com.br/api/public/v1/products/";
    }

    public LinkPagamentosHttpClient(@NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        this.environment = environment;
    }
}

