/*
 * Decompiled with CFR 0.152.
 */
package br.com.cielo.librarycielolinkpagamentos.network;

import br.com.cielo.librarycielolinkpagamentos.extension.ExtensionKt;
import br.com.cielo.librarycielolinkpagamentos.models.oauth.AccessToken;
import br.com.cielo.librarycielolinkpagamentos.models.oauth.AuthClientModel;
import br.com.cielo.librarycielolinkpagamentos.models.oauth.OAuthApi;
import br.com.cielo.librarycielolinkpagamentos.network.WebClient;
import br.com.cielo.librarycielolinkpagamentos.service.Environment;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Credentials;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007JL\u0010\b\u001a\u00020\t2!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\t0\u000b2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\t0\u000bJ\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lbr/com/cielo/librarycielolinkpagamentos/network/CredentialsHttpClient;", "", "environment", "Lbr/com/cielo/librarycielolinkpagamentos/service/Environment;", "clientId", "", "clientSecret", "(Lbr/com/cielo/librarycielolinkpagamentos/service/Environment;Ljava/lang/String;Ljava/lang/String;)V", "getOAuthCredentials", "", "onSuccessCallback", "Lkotlin/Function1;", "Lbr/com/cielo/librarycielolinkpagamentos/models/oauth/AccessToken;", "Lkotlin/ParameterName;", "name", "model", "onError", "error", "useSandbox", "librarycielolinkpagamentos_release"})
public final class CredentialsHttpClient {
    private final Environment environment;
    private final String clientId;
    private final String clientSecret;

    public final void getOAuthCredentials(@NotNull Function1<? super AccessToken, Unit> onSuccessCallback, @NotNull Function1<? super String, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onSuccessCallback, (String)"onSuccessCallback");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        String authorizationHeaderValue = Credentials.basic((String)this.clientId, (String)this.clientSecret);
        WebClient webClient = new WebClient(this.useSandbox(this.environment));
        String string = authorizationHeaderValue;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"authorizationHeaderValue");
        Call<AuthClientModel> call = webClient.createService(OAuthApi.class).getTokenOAuth(string, "client_credentials");
        call.enqueue((Callback)new Callback<AuthClientModel>(onError, onSuccessCallback){
            final /* synthetic */ Function1 $onError;
            final /* synthetic */ Function1 $onSuccessCallback;

            public void onFailure(@NotNull Call<AuthClientModel> call, @NotNull Throwable t) {
                block0: {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    String string = t.getMessage();
                    if (string == null) break block0;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    this.$onError.invoke((Object)it);
                }
            }

            public void onResponse(@NotNull Call<AuthClientModel> call, @NotNull Response<AuthClientModel> response) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                if (response.isSuccessful()) {
                    AuthClientModel authClientModel = (AuthClientModel)response.body();
                    if (authClientModel != null) {
                        AuthClientModel authClientModel2 = authClientModel;
                        boolean bl = false;
                        boolean bl2 = false;
                        AuthClientModel $this$apply = authClientModel2;
                        boolean bl3 = false;
                        String string = $this$apply.getAccessToken();
                        int n = $this$apply.getExpiresIn();
                        Calendar calendar = Calendar.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
                        Date date = calendar.getTime();
                        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"Calendar.getInstance().time");
                        this.$onSuccessCallback.invoke((Object)new AccessToken(string, n, date));
                    }
                    if (response.body() == null) {
                        this.$onError.invoke((Object)"The response object is null.");
                    }
                } else {
                    this.$onError.invoke((Object)("error " + response.code() + ' ' + (Object)((Object)ExtensionKt.toStatusCode(response.code()))));
                }
            }
            {
                this.$onError = $captured_local_variable$0;
                this.$onSuccessCallback = $captured_local_variable$1;
            }
        });
    }

    private final String useSandbox(Environment environment) {
        return environment == Environment.SANDBOX ? "https://meucheckoutsandbox.braspag.com.br/api/public/" : "https://cieloecommerce.cielo.com.br/api/public/v2/token/";
    }

    public CredentialsHttpClient(@NotNull Environment environment, @NotNull String clientId, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.environment = environment;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }
}

