/*
 * Decompiled with CFR 0.152.
 */
package br.com.arch.toolkit.statemachine;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.view.ViewGroup;
import br.com.arch.toolkit.statemachine.StateMachine;

public final class SceneStateMachine
extends StateMachine<State> {
    @Override
    @NonNull
    public State newStateInstance() {
        return new State();
    }

    @Override
    protected void performChangeState(@NonNull State state) {
        if (state.scene == null) {
            return;
        }
        boolean attached = state.scene.getSceneRoot().isAttachedToWindow();
        if (state.transition == null || !attached) {
            state.scene.enter();
        } else {
            TransitionManager.go((Scene)state.scene, (Transition)state.transition.clone());
        }
    }

    public static final class State
    extends StateMachine.State {
        @Nullable
        private Scene scene;
        @Nullable
        private Transition transition;

        private State() {
        }

        public State scene(@LayoutRes int sceneLayout, @NonNull ViewGroup container) {
            this.scene = Scene.getSceneForLayout((ViewGroup)container, (int)sceneLayout, (Context)container.getContext());
            return this;
        }

        public State scene(@NonNull Scene scene) {
            this.scene = scene;
            return this;
        }

        public State transition(@NonNull Transition transition) {
            this.transition = transition;
            return this;
        }

        @Override
        public State onEnter(@NonNull StateMachine.State.Callback callback) {
            return (State)super.onEnter(callback);
        }

        @Override
        public State onExit(@NonNull StateMachine.State.Callback callback) {
            return (State)super.onExit(callback);
        }
    }
}

