/*
 * Decompiled with CFR 0.152.
 */
package br.com.arch.toolkit.livedata.computable;

import android.arch.lifecycle.LiveData;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import br.com.arch.toolkit.livedata.ExecutorUtil;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ComputableLiveData<T>
extends LiveData<T> {
    private final Object lock = new Object();
    private final AtomicBoolean computing = new AtomicBoolean(false);
    private final AtomicBoolean computed = new AtomicBoolean(false);
    @Nullable
    private WeakReference<Thread> lastThread = null;

    @WorkerThread
    abstract void compute();

    abstract void abort();

    public boolean isRunning() {
        return this.computing.get();
    }

    public boolean hasComputed() {
        return this.computed.get();
    }

    public boolean isRunningOrHasComputed() {
        return this.computed.get() || this.computing.get();
    }

    public void invalidate() {
        if (!this.hasObservers() && this.computed.get()) {
            this.computed.set(false);
        } else if (!this.computing.get()) {
            this.computed.set(false);
            this.lastThread = new WeakReference<Thread>(ExecutorUtil.async(this::executeRunnable));
        }
    }

    public void interrupt() {
        if (this.lastThread != null && this.lastThread.get() != null) {
            ((Thread)this.lastThread.get()).interrupt();
        }
        this.abort();
        this.computing.set(false);
        this.computed.set(false);
    }

    protected void onActive() {
        super.onActive();
        if (!this.computed.get()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRunnable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.computed.get()) {
                return;
            }
            try {
                this.computing.set(true);
                this.compute();
                this.computed.set(true);
            }
            catch (Exception error) {
                this.computed.set(false);
            }
            finally {
                this.computing.set(false);
            }
        }
    }
}

