/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.flatfile.type.component;

import br.com.anteros.core.utils.ObjectUtils;
import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.flatfile.type.Field;
import br.com.anteros.flatfile.type.FixedField;
import br.com.anteros.flatfile.type.component.BlockOfFields;
import br.com.anteros.flatfile.type.component.RecordFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Record
extends BlockOfFields
implements br.com.anteros.flatfile.Record {
    private String name;
    private String description;
    private br.com.anteros.flatfile.type.component.FixedField<String> idType;
    private br.com.anteros.flatfile.type.component.FixedField<Long> sequencialNumber;
    private boolean headOfGroup;
    private List<br.com.anteros.flatfile.Record> innerRecords;
    private Set<String> repitablesRecords;
    private List<String> declaredInnerRecords;

    public Record() {
    }

    public Record(Integer length, Integer size) {
        super(length, size);
    }

    @Override
    public Record clone() throws CloneNotSupportedException {
        return (Record)super.clone();
    }

    public br.com.anteros.flatfile.type.component.FixedField<String> readID(String lineRecord) {
        br.com.anteros.flatfile.type.component.Field ffID = null;
        try {
            ffID = this.getIdType().clone();
            ffID.clearName();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(String.format("Quebra de contrato [%s] n\u00e3o suporta clonagem!", (Object[])ObjectUtils.whenNull((Object)ffID, (Object)"FixedField", ffID.getClass())), e);
        }
        ((br.com.anteros.flatfile.type.component.FixedField)ffID).read(lineRecord.substring(this.getIdPosition(), this.getIdPosition() + this.getIdType().getFixedLength()));
        return ffID;
    }

    public FixedField<?> getField(String fieldName) {
        br.com.anteros.flatfile.type.component.FixedField field = null;
        if (StringUtils.isNotBlank((CharSequence)fieldName) && !this.getFields().isEmpty()) {
            for (br.com.anteros.flatfile.type.component.FixedField ff : this.getFields()) {
                if (!ff.getName().equals(fieldName)) continue;
                field = ff;
                break;
            }
        }
        return field;
    }

    public boolean isMyField(String idName) {
        boolean is = false;
        if (StringUtils.isNotBlank((CharSequence)idName) && !this.getFields().isEmpty()) {
            for (Field f : this.getFields()) {
                if (!idName.equals(f.getName())) continue;
                is = true;
                break;
            }
        }
        return is;
    }

    private int getIdPosition() {
        br.com.anteros.flatfile.type.component.FixedField ff;
        int pos = 0;
        Iterator iterator = this.getFields().iterator();
        while (iterator.hasNext() && !(ff = (br.com.anteros.flatfile.type.component.FixedField)iterator.next()).getName().equals(this.idType.getName())) {
            pos += ff.getFixedLength().intValue();
        }
        return pos;
    }

    public int readInnerRecords(List<String> lines, int lineIndex, RecordFactory<Record> iFactory) {
        return this.readInnerRecords(this, lines, lineIndex, iFactory);
    }

    private int readInnerRecords(Record record, List<String> lines, int lineIndex, RecordFactory<Record> iFactory) {
        if (ObjectUtils.isNotNull((Object)record) && ObjectUtils.isNotNull(record.getDeclaredInnerRecords()) && !record.getDeclaredInnerRecords().isEmpty()) {
            boolean read = true;
            String line = null;
            br.com.anteros.flatfile.type.component.FixedField<String> typeRecord = null;
            Record innerRec = null;
            for (String id : record.getDeclaredInnerRecords()) {
                innerRec = iFactory.create(id);
                try {
                    if (this.isRepitable(id)) {
                        while (read) {
                            if (ObjectUtils.isNull((Object)innerRec)) {
                                innerRec = iFactory.create(id);
                            }
                            if (lineIndex < lines.size()) {
                                line = lines.get(lineIndex);
                            }
                            typeRecord = innerRec.readID(line);
                            read = ((String)innerRec.getIdType().getValue()).equals(typeRecord.getValue()) && lineIndex < lines.size();
                            if (!read) continue;
                            innerRec.read(line);
                            ++lineIndex;
                            record.addInnerRecord(innerRec);
                            if (innerRec.isHeadOfGroup()) {
                                innerRec.readInnerRecords(lines, lineIndex, iFactory);
                            }
                            innerRec = null;
                        }
                        continue;
                    }
                    if (lineIndex >= lines.size()) continue;
                    line = lines.get(lineIndex);
                    typeRecord = innerRec.readID(line);
                    if (!((String)innerRec.getIdType().getValue()).equals(typeRecord.getValue())) continue;
                    innerRec.read(line);
                    ++lineIndex;
                    record.addInnerRecord(innerRec);
                    if (innerRec.isHeadOfGroup()) {
                        innerRec.readInnerRecords(lines, lineIndex, iFactory);
                    }
                    innerRec = null;
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Erro ao tentar ler o registro \"%s\".", innerRec.getName()), e);
                }
            }
        }
        return lineIndex;
    }

    public List<String> writeInnerRecords() {
        return this.writeInnerRecords(this, "");
    }

    public List<String> writeInnerRecords(String lineEnding) {
        return this.writeInnerRecords(this, lineEnding);
    }

    private List<String> writeInnerRecords(Record record, String lineEnding) {
        ArrayList<String> out = new ArrayList<String>(record.getInnerRecords().size());
        for (String id : this.getDeclaredInnerRecords()) {
            if (this.isRepitable(id)) {
                for (Record rec : this.getRecords(id)) {
                    try {
                        out.add(rec.write() + lineEnding);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(String.format("Erro ao tentar escrever o registro \"%s\".", rec.getName()), e);
                    }
                    if (!rec.isHeadOfGroup()) continue;
                    out.addAll(rec.writeInnerRecords());
                }
                continue;
            }
            Record rec = this.getRecord(id);
            try {
                out.add(rec.write() + lineEnding);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Erro ao tentar escrever o registro \"%s\".", rec.getName()), e);
            }
            if (!rec.isHeadOfGroup()) continue;
            out.addAll(rec.writeInnerRecords());
        }
        return out;
    }

    public Record getRecord(String idName) {
        Record record = null;
        if (StringUtils.isNotBlank((CharSequence)idName) && !this.isRepitable(idName) && !this.getInnerRecords().isEmpty()) {
            for (br.com.anteros.flatfile.Record iRec : this.getInnerRecords()) {
                Record rec = (Record)iRec;
                if (!idName.equals(rec.getName())) continue;
                record = rec;
            }
        }
        return record;
    }

    public List<Record> getRecords(String idName) {
        ArrayList<Record> secRecords = new ArrayList<Record>();
        if (StringUtils.isNotBlank((CharSequence)idName) && this.isRepitable(idName) && !this.getInnerRecords().isEmpty()) {
            for (br.com.anteros.flatfile.Record iRec : this.getInnerRecords()) {
                Record rec = (Record)iRec;
                if (!idName.equals(rec.getName())) continue;
                secRecords.add(rec);
            }
        }
        return secRecords;
    }

    public boolean isRepitable(String idName) {
        return ObjectUtils.isNotNull(this.repitablesRecords) && !this.repitablesRecords.isEmpty() && this.repitablesRecords.contains(idName);
    }

    public boolean isMyRecord(String idName) {
        boolean is = false;
        if (StringUtils.isNotBlank((CharSequence)idName) && !this.getDeclaredInnerRecords().isEmpty() && this.getDeclaredInnerRecords().contains(idName)) {
            is = true;
        }
        return is;
    }

    @Override
    public br.com.anteros.flatfile.Record addInnerRecord(br.com.anteros.flatfile.Record record) {
        if (ObjectUtils.isNotNull((Object)record)) {
            if (ObjectUtils.isNull(this.innerRecords)) {
                this.innerRecords = new ArrayList<br.com.anteros.flatfile.Record>();
            }
            if (this.isMyRecord(((Record)Record.class.cast(record)).getName())) {
                this.innerRecords.add(record);
            } else {
                throw new IllegalArgumentException("Record fora de scopo!");
            }
        }
        return this;
    }

    @Override
    public List<br.com.anteros.flatfile.Record> getInnerRecords() {
        return this.innerRecords;
    }

    @Override
    public <G> G getValue(String fieldName) {
        G value = null;
        FixedField<?> f = this.getField(fieldName);
        if (ObjectUtils.isNotNull(f)) {
            value = f.getValue();
        }
        return value;
    }

    @Override
    public <G> br.com.anteros.flatfile.Record setValue(String fieldName, G value) {
        FixedField<?> f = this.getField(fieldName);
        if (ObjectUtils.isNotNull(f)) {
            f.setValue(value);
        }
        return this;
    }

    public boolean hasInnerRecords() {
        return this.getInnerRecords() != null && !this.getInnerRecords().isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public br.com.anteros.flatfile.type.component.FixedField<String> getIdType() {
        return this.idType;
    }

    public void setIdType(br.com.anteros.flatfile.type.component.FixedField<String> idType) {
        this.idType = idType;
    }

    public br.com.anteros.flatfile.type.component.FixedField<Long> getSequencialNumber() {
        return this.sequencialNumber;
    }

    public void setSequencialNumber(br.com.anteros.flatfile.type.component.FixedField<Long> sequencialNumber) {
        this.sequencialNumber = sequencialNumber;
    }

    public boolean isHeadOfGroup() {
        return this.headOfGroup;
    }

    public void setHeadOfGroup(boolean headOfGroup) {
        this.headOfGroup = headOfGroup;
    }

    public List<String> getDeclaredInnerRecords() {
        return this.declaredInnerRecords;
    }

    public void setDeclaredInnerRecords(List<String> declaredInnerRecords) {
        this.declaredInnerRecords = declaredInnerRecords;
    }

    public Set<String> getRepitablesRecords() {
        return this.repitablesRecords;
    }

    public void setRepitablesRecords(Set<String> repitablesRecords) {
        this.repitablesRecords = repitablesRecords;
    }
}

