/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.flatfile.engine;

import br.com.anteros.core.utils.ObjectUtils;
import br.com.anteros.core.utils.ResourceUtils;
import br.com.anteros.flatfile.Texgit;
import br.com.anteros.flatfile.TexgitException;
import br.com.anteros.flatfile.engine.TexgitLanguageException;
import br.com.anteros.flatfile.engine.TexgitSchemaValidator;
import br.com.anteros.flatfile.language.MetaTexgit;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

class TexgitXmlReader {
    TexgitXmlReader() {
    }

    public static MetaTexgit parse(InputStream xmlDefStream) throws TexgitException {
        MetaTexgit txg = null;
        if (ObjectUtils.isNotNull((Object)xmlDefStream)) {
            try {
                JAXBContext aJaxbContext = JAXBContext.newInstance((Class[])new Class[]{MetaTexgit.class});
                Unmarshaller aUnmarshaller = aJaxbContext.createUnmarshaller();
                SchemaFactory aSchemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = aSchemaFactory.newSchema(ResourceUtils.getResource((String)"TexgitSchema.xsd", Texgit.class));
                aUnmarshaller.setSchema(schema);
                aUnmarshaller.setEventHandler((ValidationEventHandler)new TexgitSchemaValidator());
                txg = (MetaTexgit)aUnmarshaller.unmarshal(xmlDefStream);
            }
            catch (SAXException e) {
                throw new TexgitLanguageException(e);
            }
            catch (JAXBException e) {
                throw new TexgitLanguageException(e);
            }
        }
        return txg;
    }
}

