/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderConfiguration;
import biz.paluch.logging.gelf.intern.GelfSenderProvider;
import biz.paluch.logging.gelf.intern.sender.GelfTCPSender;
import biz.paluch.logging.gelf.intern.sender.GelfUDPSender;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DefaultGelfSenderProvider
implements GelfSenderProvider {
    public static final int DEFAULT_PORT = 12201;

    @Override
    public boolean supports(String host) {
        return host != null;
    }

    @Override
    public GelfSender create(GelfSenderConfiguration configuration) throws IOException {
        String graylogHost = configuration.getHost();
        int port = configuration.getPort();
        if (port == 0) {
            port = 12201;
        }
        if (graylogHost.startsWith("tcp:")) {
            int timeoutMs = (int)TimeUnit.MILLISECONDS.convert(2L, TimeUnit.SECONDS);
            String tcpGraylogHost = graylogHost.substring(4, graylogHost.length());
            return new GelfTCPSender(tcpGraylogHost, port, timeoutMs, timeoutMs, configuration.getErrorReporter());
        }
        if (graylogHost.startsWith("udp:")) {
            String udpGraylogHost = graylogHost.substring(4, graylogHost.length());
            return new GelfUDPSender(udpGraylogHost, port, configuration.getErrorReporter());
        }
        return new GelfUDPSender(graylogHost, port, configuration.getErrorReporter());
    }
}

