/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderConfiguration;
import biz.paluch.logging.gelf.intern.GelfSenderProvider;
import biz.paluch.logging.gelf.intern.HostAndPortProvider;
import biz.paluch.logging.gelf.intern.sender.DefaultGelfSenderProvider;
import biz.paluch.logging.gelf.intern.sender.RedisGelfSenderProvider;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public final class GelfSenderFactory {
    public static GelfSender createSender(final HostAndPortProvider hostAndPortProvider, final ErrorReporter errorReporter, final Map<String, Object> senderSpecificConfigurations) {
        GelfSenderConfiguration senderConfiguration = new GelfSenderConfiguration(){

            @Override
            public int getPort() {
                return hostAndPortProvider.getPort();
            }

            @Override
            public String getHost() {
                return hostAndPortProvider.getHost();
            }

            @Override
            public ErrorReporter getErrorReporter() {
                return errorReporter;
            }

            @Override
            public Map<String, Object> getSpecificConfigurations() {
                return senderSpecificConfigurations;
            }
        };
        return GelfSenderFactory.createSender(senderConfiguration);
    }

    public static GelfSender createSender(GelfSenderConfiguration senderConfiguration) {
        ErrorReporter errorReporter = senderConfiguration.getErrorReporter();
        if (senderConfiguration.getHost() == null) {
            senderConfiguration.getErrorReporter().reportError("GELF server hostname is empty!", null);
        } else {
            try {
                for (GelfSenderProvider provider : SenderProviderHolder.getSenderProvider()) {
                    if (!provider.supports(senderConfiguration.getHost())) continue;
                    return provider.create(senderConfiguration);
                }
                senderConfiguration.getErrorReporter().reportError("No sender found for host " + senderConfiguration.getHost(), null);
                return null;
            }
            catch (UnknownHostException e) {
                errorReporter.reportError("Unknown GELF server hostname:" + senderConfiguration.getHost(), e);
            }
            catch (SocketException e) {
                errorReporter.reportError("Socket exception: " + e.getMessage(), e);
            }
            catch (IOException e) {
                errorReporter.reportError("IO exception: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public static void addGelfSenderProvider(GelfSenderProvider provider) {
        SenderProviderHolder.addSenderProvider(provider);
    }

    public static void removeGelfSenderProvider(GelfSenderProvider provider) {
        SenderProviderHolder.removeSenderProvider(provider);
    }

    public static void removeAllAddedSenderProviders() {
        SenderProviderHolder.removeAllAddedSenderProviders();
    }

    private static class SenderProviderHolder {
        private static ServiceLoader<GelfSenderProvider> gelfSenderProvider = ServiceLoader.load(GelfSenderProvider.class);
        private static List<GelfSenderProvider> providerList = new ArrayList<GelfSenderProvider>();
        private static List<GelfSenderProvider> addedProviders = new ArrayList<GelfSenderProvider>();

        private SenderProviderHolder() {
        }

        static List<GelfSenderProvider> getSenderProvider() {
            return providerList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void addSenderProvider(GelfSenderProvider provider) {
            List<GelfSenderProvider> list = providerList;
            synchronized (list) {
                addedProviders.add(provider);
                if (!providerList.contains(provider)) {
                    providerList.add(0, provider);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void removeAllAddedSenderProviders() {
            List<GelfSenderProvider> list = providerList;
            synchronized (list) {
                providerList.removeAll(addedProviders);
                addedProviders.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void removeSenderProvider(GelfSenderProvider provider) {
            List<GelfSenderProvider> list = providerList;
            synchronized (list) {
                addedProviders.remove(provider);
                providerList.remove(provider);
            }
        }

        static {
            Iterator<GelfSenderProvider> iter = gelfSenderProvider.iterator();
            while (iter.hasNext()) {
                providerList.add(iter.next());
            }
            providerList.add(new RedisGelfSenderProvider());
            providerList.add(new DefaultGelfSenderProvider());
        }
    }
}

