/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.startuphook.impl;

import biz.netcentric.cq.tools.actool.api.AcInstallationService;
import biz.netcentric.cq.tools.actool.helper.runtime.RuntimeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Config.class)
public class AcToolStartupHookServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(AcToolStartupHookServiceImpl.class);
    private static final String THREAD_NAME_ASYNC = "actool-async";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private AcInstallationService acInstallationService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingRepository repository;
    private boolean isCompositeNodeStore;

    @Activate
    public void activate(BundleContext bundleContext, Config config) {
        boolean applyOnStartup;
        boolean isCloudReady = RuntimeHelper.isCloudReadyInstance();
        Config.StartupHookActivation activationMode = config.activationMode();
        boolean runAsyncForMutableConent = config.runAsyncForMutableConent();
        int currentStartLevel = RuntimeHelper.getCurrentStartLevel(bundleContext);
        LOG.info("AcTool Startup Hook (start level: {}  isCloudReady: {}  activationMode: {}  runAsyncForMutableConent: {})", new Object[]{currentStartLevel, isCloudReady, activationMode, runAsyncForMutableConent});
        boolean bl = applyOnStartup = activationMode == Config.StartupHookActivation.ALWAYS || isCloudReady && activationMode == Config.StartupHookActivation.CLOUD_ONLY;
        if (applyOnStartup) {
            List<String> relevantPathsForInstallation = this.getRelevantPathsForInstallation();
            LOG.info("Running AcTool with " + (relevantPathsForInstallation.isEmpty() ? "all paths" : "paths " + relevantPathsForInstallation) + "...");
            if (runAsyncForMutableConent && this.isCompositeNodeStore) {
                LOG.info("Running AcTool asynchronously on mutable content of composite node store (config runAsyncForMutableConent=true)...");
                this.runAcToolAsync(relevantPathsForInstallation, currentStartLevel, isCloudReady);
            } else {
                this.runAcTool(relevantPathsForInstallation, currentStartLevel, isCloudReady);
            }
        } else {
            LOG.debug("Skipping AcTool Startup Hook: activationMode: {} isCloudReady: {}", (Object)activationMode, (Object)isCloudReady);
        }
    }

    private void runAcTool(List<String> relevantPathsForInstallation, int currentStartLevel, boolean isCloudReady) {
        this.acInstallationService.apply(null, relevantPathsForInstallation.toArray(new String[relevantPathsForInstallation.size()]), true);
        LOG.info("AC Tool Startup Hook done. (start level {})", (Object)currentStartLevel);
        this.copyAcHistoryToOrFromApps(isCloudReady);
    }

    private void runAcToolAsync(final List<String> relevantPathsForInstallation, final int currentStartLevel, final boolean isCloudReady) {
        final AcToolStartupHookServiceImpl startupHook = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                startupHook.runAcTool(relevantPathsForInstallation, currentStartLevel, isCloudReady);
            }
        }, THREAD_NAME_ASYNC).start();
    }

    private List<String> getRelevantPathsForInstallation() {
        Session session = null;
        try {
            session = this.repository.loginService(null, null);
            this.isCompositeNodeStore = RuntimeHelper.isCompositeNodeStore(session);
            LOG.info("Repo is running with Composite NodeStore: {}", (Object)this.isCompositeNodeStore);
            if (!this.isCompositeNodeStore) {
                List<String> list = Collections.emptyList();
                return list;
            }
            NodeIterator nodes = session.getRootNode().getNodes();
            ArrayList<String> relevantPathsForInstallation = new ArrayList<String>();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                if (Arrays.asList("jcr:system", "oak:index", "rep:policy", "rep:repoPolicy").contains(node.getName()) || this.isCompositeNodeStore && Arrays.asList("apps", "libs").contains(node.getName())) continue;
                relevantPathsForInstallation.add(node.getPath());
            }
            relevantPathsForInstallation.add("^/$");
            relevantPathsForInstallation.add("^$");
            ArrayList<String> arrayList = relevantPathsForInstallation;
            return arrayList;
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Could not retrieve relevant base paths for AC Tool installation: " + (Object)((Object)e), e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAcHistoryToOrFromApps(boolean isCloudReady) {
        if (isCloudReady) {
            Session session = null;
            try {
                session = this.repository.loginService(null, null);
                if (this.isCompositeNodeStore) {
                    LOG.info("Restoring history from /apps to /var");
                    if (session.nodeExists("/apps/netcentric/achistory")) {
                        NodeIterator nodesInAppsIt = session.getNode("/apps/netcentric/achistory").getNodes();
                        while (nodesInAppsIt.hasNext()) {
                            Node historyNodeInApps = nodesInAppsIt.nextNode();
                            String historyNodeInVarPath = "/var/statistics/achistory/" + historyNodeInApps.getName();
                            if (session.nodeExists(historyNodeInVarPath)) continue;
                            LOG.info("   restoring history node {} to {}", (Object)historyNodeInApps.getPath(), (Object)historyNodeInVarPath);
                            session.getWorkspace().copy(historyNodeInApps.getPath(), historyNodeInVarPath);
                        }
                    }
                } else {
                    LOG.info("Saving history in /apps (to make it accessible later when running in composite node store)");
                    LOG.info("   copying node {} to {}", (Object)"/var/statistics/achistory", (Object)"/apps/netcentric/achistory");
                    session.getWorkspace().copy("/var/statistics/achistory", "/apps/netcentric/achistory");
                }
                session.save();
            }
            catch (RepositoryException e) {
                LOG.warn("Could not copy AC History node from/to /apps: " + (Object)((Object)e), (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    @ObjectClassDefinition(name="AC Tool Startup Hook", description="Applies AC Tool config automatically upon startup (depending on configuration/runtime)")
    public static @interface Config {
        @AttributeDefinition(name="Activation Mode", description="Apply on startup - CLOUD_ONLY autodetects the cloud (by missing OSGi installer bundle) and only runs on startup if deployed in the cloud. ALWAYS can be useful for local testing. NEVER disables AC Tool runs on startup entirely.")
        public StartupHookActivation activationMode() default StartupHookActivation.CLOUD_ONLY;

        @AttributeDefinition(name="Async for Mutable Content", description="Will execute on the mutable content asynchronously using a Sling Job")
        public boolean runAsyncForMutableConent() default false;

        public static enum StartupHookActivation {
            ALWAYS,
            CLOUD_ONLY,
            NEVER;

        }
    }
}

