/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.impl;

import biz.netcentric.cq.tools.actool.aceinstaller.AceBeanInstaller;
import biz.netcentric.cq.tools.actool.api.AcInstallationService;
import biz.netcentric.cq.tools.actool.api.InstallationLog;
import biz.netcentric.cq.tools.actool.authorizableinstaller.AuthorizableCreatorException;
import biz.netcentric.cq.tools.actool.authorizableinstaller.AuthorizableInstallerService;
import biz.netcentric.cq.tools.actool.configmodel.AcConfiguration;
import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.configmodel.AcesConfig;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizablesConfig;
import biz.netcentric.cq.tools.actool.configreader.ConfigFilesRetriever;
import biz.netcentric.cq.tools.actool.configreader.ConfigReader;
import biz.netcentric.cq.tools.actool.configreader.ConfigurationMerger;
import biz.netcentric.cq.tools.actool.dumpservice.ConfigDumpService;
import biz.netcentric.cq.tools.actool.helper.AcHelper;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.helper.AclBean;
import biz.netcentric.cq.tools.actool.helper.PurgeHelper;
import biz.netcentric.cq.tools.actool.helper.QueryHelper;
import biz.netcentric.cq.tools.actool.helper.runtime.RuntimeHelper;
import biz.netcentric.cq.tools.actool.history.AcHistoryService;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import biz.netcentric.cq.tools.actool.history.impl.PersistableInstallationLogger;
import biz.netcentric.cq.tools.actool.impl.AcConfigChangeTracker;
import biz.netcentric.cq.tools.actool.impl.AcInstallationServiceInternal;
import biz.netcentric.cq.tools.actool.slingsettings.ExtendedSlingSettingsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Configuration.class)
public class AcInstallationServiceImpl
implements AcInstallationService,
AcInstallationServiceInternal {
    private static final Logger LOG = LoggerFactory.getLogger(AcInstallationServiceImpl.class);
    private static final String CONFIG_PID = "biz.netcentric.cq.tools.actool.impl.AcInstallationServiceImpl";
    private static final String LEGACY_CONFIG_PID = "biz.netcentric.cq.tools.actool.aceservice.impl.AceServiceImpl";
    private static final String LEGACY_PROPERTY_CONFIGURATION_PATH = "AceService.configurationPath";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    AuthorizableInstallerService authorizableCreatorService;
    @Reference(target="(component.name=biz.netcentric.cq.tools.actool.aceinstaller.AceBeanInstallerClassic)", policyOption=ReferencePolicyOption.GREEDY)
    AceBeanInstaller aceBeanInstallerClassic;
    @Reference(target="(component.name=biz.netcentric.cq.tools.actool.aceinstaller.AceBeanInstallerIncremental)", policyOption=ReferencePolicyOption.GREEDY)
    AceBeanInstaller aceBeanInstallerIncremental;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingRepository repository;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    AcHistoryService acHistoryService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ConfigDumpService dumpservice;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ConfigReader configReader;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ConfigurationMerger configurationMerger;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ConfigFilesRetriever configFilesRetriever;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ConfigurationAdmin configAdmin;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private AcConfigChangeTracker acConfigChangeTracker;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ExtendedSlingSettingsService slingSettingsService;
    private List<String> configurationRootPaths;

    @Activate
    public void activate(Configuration configuration, BundleContext bundleContext) throws Exception {
        Dictionary legacyProps;
        Dictionary configDict = this.configAdmin.getConfiguration(CONFIG_PID).getProperties();
        this.configurationRootPaths = new ArrayList<String>();
        if (!ArrayUtils.isEmpty((Object[])configuration.configurationRootPaths())) {
            this.configurationRootPaths.addAll(Arrays.asList(configuration.configurationRootPaths()));
        } else if (configDict != null && configDict.get(LEGACY_PROPERTY_CONFIGURATION_PATH) != null) {
            LOG.warn("Using legacy property PID '{}' is deprecated, use 'configurationRootPaths' instead. ", (Object)LEGACY_PROPERTY_CONFIGURATION_PATH);
            this.configurationRootPaths.add(PropertiesUtil.toString(configDict.get(LEGACY_PROPERTY_CONFIGURATION_PATH), (String)""));
        }
        if (configDict == null && (legacyProps = this.configAdmin.getConfiguration(LEGACY_CONFIG_PID).getProperties()) != null) {
            LOG.warn("Using legacy configuration PID '{}'. Please remove this and switch to the new one with PID '{}',", (Object)LEGACY_CONFIG_PID, (Object)CONFIG_PID);
            this.configurationRootPaths = Arrays.asList(PropertiesUtil.toString(legacyProps.get(LEGACY_PROPERTY_CONFIGURATION_PATH), (String)""));
        }
        LOG.info("Activated AC Tool at start level " + RuntimeHelper.getCurrentStartLevel(bundleContext) + " default config path: " + this.configurationRootPaths);
    }

    @Override
    public InstallationLog apply() {
        return this.apply(null, null);
    }

    @Override
    public InstallationLog apply(String configurationRootPath) {
        return this.apply(configurationRootPath, null);
    }

    @Override
    public InstallationLog apply(String[] restrictedToPaths) {
        return this.apply(null, restrictedToPaths);
    }

    @Override
    public InstallationLog apply(String configurationRootPath, String[] restrictedToPaths) {
        return this.apply(configurationRootPath, restrictedToPaths, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallationLog apply(String configurationRootPath, String[] restrictedToPaths, boolean skipIfConfigUnchanged) {
        if (StringUtils.isBlank((CharSequence)configurationRootPath)) {
            if (CollectionUtils.isEmpty(this.configurationRootPaths)) {
                throw new IllegalArgumentException("Configuration root path neither configured nor provided.");
            }
            if (this.configurationRootPaths.size() == 1) {
                configurationRootPath = this.configurationRootPaths.get(0);
            } else {
                return this.applyMultipleConfigurations(restrictedToPaths, skipIfConfigUnchanged);
            }
        }
        PersistableInstallationLogger installLog = new PersistableInstallationLogger();
        Session session = null;
        try {
            Map<String, String> configFiles;
            session = this.repository.loginService(null, null);
            try {
                configFiles = this.configFilesRetriever.getConfigFileContentFromNode(configurationRootPath, session);
            }
            catch (Exception e) {
                installLog.addError("Could not retrieve configuration from path " + configurationRootPath + ": " + e.getMessage(), e);
                this.persistHistory(installLog);
                PersistableInstallationLogger persistableInstallationLogger = installLog;
                if (session != null) {
                    session.logout();
                }
                return persistableInstallationLogger;
            }
            this.installConfigurationFiles(installLog, configFiles, restrictedToPaths, session, skipIfConfigUnchanged);
        }
        catch (AuthorizableCreatorException e) {
            LOG.warn("Exception during installation of authorizables (no rollback), e=" + e, (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Exception in AceServiceImpl: {}", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return installLog;
    }

    private InstallationLog applyMultipleConfigurations(String[] restrictedToPaths, boolean skipIfConfigUnchanged) {
        PersistableInstallationLogger overviewInstallLog = new PersistableInstallationLogger();
        overviewInstallLog.addMessage(LOG, "Applying multiple configs (this log only shows what was applied, check the individual logs for details)");
        for (String rootPath : this.configurationRootPaths) {
            overviewInstallLog.addMessage(LOG, "Applying config at root path " + rootPath);
            this.apply(rootPath, restrictedToPaths, skipIfConfigUnchanged);
        }
        return overviewInstallLog;
    }

    @Override
    public void installConfigurationFiles(PersistableInstallationLogger installLog, Map<String, String> configurationFileContentsByFilename, String[] restrictedToPaths, Session session) throws Exception {
        this.installConfigurationFiles(installLog, configurationFileContentsByFilename, restrictedToPaths, session, false);
    }

    public void installConfigurationFiles(PersistableInstallationLogger installLog, Map<String, String> configurationFileContentsByFilename, String[] restrictedToPaths, Session session, boolean skipIfConfigUnchanged) throws Exception {
        boolean configsIdenticalToLastExecution = this.acConfigChangeTracker.configIsUnchangedComparedToLastExecution(configurationFileContentsByFilename, restrictedToPaths, session);
        if (skipIfConfigUnchanged && configsIdenticalToLastExecution) {
            installLog.addMessage(LOG, "Config files are identical to last execution");
            return;
        }
        String origThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(origThreadName + "-ACTool-Config-Worker");
            StopWatch sw = new StopWatch();
            sw.start();
            installLog.addMessage(LOG, "*** Applying AC Tool Configuration...");
            installLog.addMessage(LOG, "Running with v" + this.getVersion() + " on instance id " + this.slingSettingsService.getSlingId() + (!ArrayUtils.isEmpty((Object[])restrictedToPaths) ? " with restricted paths: " + Arrays.asList(restrictedToPaths) : ""));
            if (configurationFileContentsByFilename != null) {
                installLog.setConfigFileContentsByName(configurationFileContentsByFilename);
                AcConfiguration acConfiguration = this.configurationMerger.getMergedConfigurations(configurationFileContentsByFilename, installLog, this.configReader, session);
                this.installMergedConfigurations(installLog, acConfiguration, restrictedToPaths, session);
                this.ensureVirtualGroupsAreRemoved(installLog, acConfiguration, session);
                this.removeObsoleteAuthorizables(installLog, acConfiguration.getObsoleteAuthorizables(), session);
            }
            sw.stop();
            long executionTime = sw.getTime();
            installLog.setExecutionTime(executionTime);
            installLog.addVerboseMessage(LOG, "Finished at bundle start level " + RuntimeHelper.getCurrentStartLevel());
            installLog.addMessage(LOG, "Successfully applied AC Tool configuration in " + PersistableInstallationLogger.msHumanReadable(executionTime));
        }
        catch (Exception e) {
            installLog.addError("Could not process yaml files", e);
            throw e;
        }
        finally {
            this.persistHistory(installLog);
            Thread.currentThread().setName(origThreadName);
        }
    }

    private void persistHistory(PersistableInstallationLogger installLog) {
        try {
            this.acHistoryService.persistHistory(installLog);
        }
        catch (Exception e) {
            LOG.warn("Could not persist history, e=" + e, (Throwable)e);
        }
    }

    private void installAcConfiguration(AcConfiguration acConfiguration, InstallationLogger installLog, Map<String, Set<AceBean>> repositoryDumpAceMap, String[] restrictedToPaths, Session session) throws Exception {
        if (acConfiguration.getAceConfig() == null) {
            String message = "ACE config not found in YAML file! installation aborted!";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.installAuthorizables(installLog, acConfiguration, session);
        this.installAces(installLog, acConfiguration, repositoryDumpAceMap, restrictedToPaths, session);
    }

    private void removeAcesForPathsNotInConfig(InstallationLogger installLog, Session session, Set<String> principalsInConfig, Map<String, Set<AceBean>> repositoryDumpAceMap, AcConfiguration acConfiguration) throws UnsupportedRepositoryOperationException, RepositoryException {
        int countAcesCleaned = 0;
        int countPathsCleaned = 0;
        Set<String> relevantPathsForCleanup = this.getRelevantPathsForAceCleanup(principalsInConfig, repositoryDumpAceMap, acConfiguration.getAceConfig());
        for (String relevantPath : relevantPathsForCleanup) {
            Set<String> principalsToRemoveAcesForAtThisPath;
            int countRemoved = AccessControlUtils.deleteAllEntriesForPrincipalsFromACL(session, relevantPath, (principalsToRemoveAcesForAtThisPath = acConfiguration.getAuthorizablesConfig().removeUnmanagedPrincipalNamesAtPath(relevantPath, principalsInConfig, acConfiguration.getGlobalConfiguration().getDefaultUnmanagedAcePathsRegex())).toArray(new String[principalsToRemoveAcesForAtThisPath.size()]));
            if (countRemoved > 0) {
                ++countPathsCleaned;
                installLog.addMessage(LOG, "For paths not contained in the configuration: Cleaned " + countRemoved + " ACEs of path " + relevantPath + " from all ACEs for configured authorizables");
            }
            countAcesCleaned += countRemoved;
        }
        if (countAcesCleaned > 0) {
            installLog.addMessage(LOG, "For paths not contained in the configuration: Cleaned " + countAcesCleaned + " ACEs from " + countPathsCleaned + " paths in repository (ACEs that belong to users in the AC Config, but resided at paths that are not contained in AC Config)");
        }
    }

    private Set<String> getRelevantPathsForAceCleanup(Set<String> authorizablesInConfig, Map<String, Set<AceBean>> repositoryDumpAceMap, AcesConfig aceBeansFromConfig) {
        HashSet<String> relevantPathsForCleanup = new HashSet<String>();
        for (Map.Entry<String, Set<AceBean>> entry : repositoryDumpAceMap.entrySet()) {
            Set<AceBean> existingAcl = entry.getValue();
            for (AceBean existingAceFromDump : existingAcl) {
                String jcrPath = existingAceFromDump.getJcrPath();
                String principalName = existingAceFromDump.getPrincipalName();
                if (aceBeansFromConfig.containsPath(jcrPath)) {
                    LOG.trace("Path {} is explicitly listed in config and hence that ACL is handled later, not preceding cleanup needed here", (Object)jcrPath);
                    continue;
                }
                if (!authorizablesInConfig.contains(principalName)) {
                    LOG.debug("Principal {} is not contained in config, hence not cleaning its ACE from non-config-contained path {}", (Object)principalName, (Object)jcrPath);
                    continue;
                }
                relevantPathsForCleanup.add(jcrPath);
            }
        }
        return relevantPathsForCleanup;
    }

    boolean isRelevantPath(String path, String[] restrictedToPaths) {
        if (restrictedToPaths == null || restrictedToPaths.length == 0) {
            return true;
        }
        boolean isRelevant = false;
        for (String restrictedToPath : restrictedToPaths) {
            String regexStr;
            boolean isRegEx = StringUtils.containsAny((CharSequence)restrictedToPath, (char[])new char[]{'*', '^', '$', '+'});
            String string = regexStr = isRegEx ? restrictedToPath : "^" + restrictedToPath + "(/.*|$)";
            if (!path.matches(regexStr)) continue;
            isRelevant = true;
        }
        return isRelevant;
    }

    private Set<String> getPrincipalNamesToRemoveAcesFor(AuthorizablesConfig authorizablesBeansfromConfig) {
        Set<String> principalsToBeMigrated;
        Set<String> principalsToRemoveAcesFor = authorizablesBeansfromConfig.getPrincipalNames();
        Collection invalidPrincipalsInConfig = CollectionUtils.intersection(principalsToRemoveAcesFor, principalsToBeMigrated = this.collectPrincipalsToBeMigrated(authorizablesBeansfromConfig));
        if (!invalidPrincipalsInConfig.isEmpty()) {
            throw new IllegalArgumentException("If migrateFrom feature is used, groups that shall be migrated from must not be present in regular configuration (offending groups: " + invalidPrincipalsInConfig + ")");
        }
        principalsToRemoveAcesFor.addAll(principalsToBeMigrated);
        return principalsToRemoveAcesFor;
    }

    Set<String> collectPrincipalsToBeMigrated(AuthorizablesConfig authorizablesBeansfromConfig) {
        LinkedHashSet<String> principalsToBeMigrated = new LinkedHashSet<String>();
        for (AuthorizableConfigBean authorizableConfigBean : authorizablesBeansfromConfig) {
            String oldPrincipalName;
            String migrateFrom = authorizableConfigBean.getMigrateFrom();
            if (!StringUtils.isNotBlank((CharSequence)migrateFrom)) continue;
            if (StringUtils.equals((CharSequence)authorizableConfigBean.getPrincipalName(), (CharSequence)authorizableConfigBean.getAuthorizableId())) {
                principalsToBeMigrated.add(migrateFrom);
                continue;
            }
            String newPrincipalName = authorizableConfigBean.getPrincipalName();
            if (StringUtils.equals((CharSequence)newPrincipalName, (CharSequence)(oldPrincipalName = newPrincipalName.replace(authorizableConfigBean.getAuthorizableId(), migrateFrom)))) {
                throw new IllegalStateException("Could not derive old principal name from newPrincipalName=" + newPrincipalName + " and authorizableId=" + authorizableConfigBean.getAuthorizableId() + " (oldPrincipalName=" + oldPrincipalName + " is equal to new principal name)");
            }
            principalsToBeMigrated.add(oldPrincipalName);
        }
        return principalsToBeMigrated;
    }

    private void installAces(InstallationLogger installLog, AcConfiguration acConfiguration, Map<String, Set<AceBean>> repositoryDumpAceMap, String[] restrictedToPaths, Session session) throws Exception {
        Map<String, Set<AceBean>> pathBasedAceMapFromConfig = AcHelper.getPathBasedAceMap(acConfiguration.getAceConfig(), AcHelper.ACE_ORDER_ACTOOL_BEST_PRACTICE);
        Set<String> principalsToRemoveAcesFor = this.getPrincipalNamesToRemoveAcesFor(acConfiguration.getAuthorizablesConfig());
        this.removeAcesForPathsNotInConfig(installLog, session, principalsToRemoveAcesFor, repositoryDumpAceMap, acConfiguration);
        Map<String, Set<AceBean>> filteredPathBasedAceMapFromConfig = this.filterForRestrictedPaths(pathBasedAceMapFromConfig, restrictedToPaths, installLog);
        if (!filteredPathBasedAceMapFromConfig.isEmpty()) {
            AceBeanInstaller aceBeanInstaller = acConfiguration.getGlobalConfiguration().getInstallAclsIncrementally() ? this.aceBeanInstallerIncremental : this.aceBeanInstallerClassic;
            installLog.addMessage(LOG, "*** Starting installation of " + this.collectAceCount(filteredPathBasedAceMapFromConfig) + " ACE configurations for " + filteredPathBasedAceMapFromConfig.size() + " paths in content nodes using strategy " + aceBeanInstaller.getClass().getSimpleName() + "...");
            aceBeanInstaller.installPathBasedACEs(filteredPathBasedAceMapFromConfig, acConfiguration, session, installLog, principalsToRemoveAcesFor);
        } else {
            installLog.addMessage(LOG, "No relevant ACEs to install");
        }
        if (session.hasPendingChanges()) {
            session.save();
            installLog.addMessage(LOG, "Persisted changes of ACLs");
        } else {
            installLog.addMessage(LOG, "No changes were made to ACLs (session has no pending changes)");
        }
    }

    private Map<String, Set<AceBean>> filterForRestrictedPaths(Map<String, Set<AceBean>> pathBasedAceMapFromConfig, String[] restrictedToPaths, InstallationLogger installLog) {
        if (restrictedToPaths == null || restrictedToPaths.length == 0) {
            return pathBasedAceMapFromConfig;
        }
        TreeMap<String, Set<AceBean>> filteredPathBasedAceMapFromConfig = new TreeMap<String, Set<AceBean>>();
        for (String path : pathBasedAceMapFromConfig.keySet()) {
            boolean isRelevant = this.isRelevantPath(path, restrictedToPaths);
            if (!isRelevant) continue;
            filteredPathBasedAceMapFromConfig.put(path, pathBasedAceMapFromConfig.get(path));
        }
        int skipped = pathBasedAceMapFromConfig.keySet().size() - filteredPathBasedAceMapFromConfig.keySet().size();
        installLog.addMessage(LOG, "Will install AC Config at " + filteredPathBasedAceMapFromConfig.keySet().size() + " paths (skipping " + skipped + " due to paths restriction " + Arrays.toString(restrictedToPaths) + ")");
        return filteredPathBasedAceMapFromConfig;
    }

    private int collectAceCount(Map<String, Set<AceBean>> aceMapFromConfig) {
        int count = 0;
        for (Set<AceBean> acesForGroup : aceMapFromConfig.values()) {
            count += acesForGroup.size();
        }
        return count;
    }

    private void installAuthorizables(InstallationLogger installLog, AcConfiguration acConfiguration, Session session) throws RepositoryException, Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        AuthorizablesConfig authorizablesConfig = acConfiguration.getAuthorizablesConfig();
        installLog.addMessage(LOG, "*** Starting installation of " + authorizablesConfig.size() + " authorizables from configuration...");
        try {
            this.authorizableCreatorService.installAuthorizables(acConfiguration, authorizablesConfig, session, installLog);
        }
        catch (Exception e) {
            throw new AuthorizableCreatorException(e);
        }
        installLog.addMessage(LOG, "Finished installation of authorizables without errors in " + PersistableInstallationLogger.msHumanReadable(stopWatch.getTime()));
    }

    private Set<String> removeNonExistingAuthorizables(Set<String> authorizablesToCheck, Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        HashSet<String> nonExistingAuthorizables = new HashSet<String>();
        UserManager userManager = AccessControlUtils.getUserManagerAutoSaveDisabled(session);
        Iterator<String> authorizablesIt = authorizablesToCheck.iterator();
        while (authorizablesIt.hasNext()) {
            String authorizableId = authorizablesIt.next();
            Authorizable authorizable = userManager.getAuthorizable(authorizableId);
            if (authorizable != null) continue;
            nonExistingAuthorizables.add(authorizableId);
            authorizablesIt.remove();
        }
        return nonExistingAuthorizables;
    }

    private void removeObsoleteAuthorizables(InstallationLogger installLog, Set<String> obsoleteAuthorizables, Session session) {
        try {
            if (obsoleteAuthorizables.isEmpty()) {
                installLog.addVerboseMessage(LOG, "No obsolete authorizables configured");
                return;
            }
            Set<String> obsoleteAuthorizablesAlreadyPurged = this.removeNonExistingAuthorizables(obsoleteAuthorizables, session);
            if (obsoleteAuthorizables.isEmpty()) {
                installLog.addMessage(LOG, "All configured " + obsoleteAuthorizablesAlreadyPurged.size() + " obsolete authorizables have already been purged.");
                return;
            }
            installLog.addMessage(LOG, "*** Purging " + obsoleteAuthorizables.size() + " obsolete authorizables...  ");
            if (!obsoleteAuthorizablesAlreadyPurged.isEmpty()) {
                installLog.addMessage(LOG, "(" + obsoleteAuthorizablesAlreadyPurged.size() + " have been purged already)");
            }
            this.purgeAuthorizables(obsoleteAuthorizables, session, installLog, true);
            installLog.addMessage(LOG, "Successfully purged " + obsoleteAuthorizables);
        }
        catch (Exception e) {
            installLog.addError(LOG, "Could not purge obsolete authorizables " + obsoleteAuthorizables, e);
        }
    }

    private void ensureVirtualGroupsAreRemoved(InstallationLogger installLog, AcConfiguration acConfiguration, Session session) {
        try {
            List<AuthorizableConfigBean> virtualGroups = acConfiguration.getVirtualGroups();
            HashSet<String> virtualGroupIds = new HashSet<String>();
            for (AuthorizableConfigBean virtualGroup : virtualGroups) {
                virtualGroupIds.add(virtualGroup.getAuthorizableId());
            }
            if (virtualGroups.isEmpty()) {
                installLog.addVerboseMessage(LOG, "No virtual groups are configured - no need to ensure virtual groups are removed from repo.");
                return;
            }
            this.removeNonExistingAuthorizables(virtualGroupIds, session);
            if (virtualGroupIds.isEmpty()) {
                installLog.addVerboseMessage(LOG, "No virtual groups exist in repo that would require purging.");
                return;
            }
            installLog.addMessage(LOG, "Purging " + virtualGroupIds.size() + " virtual groups from repository (most likely they were non-virtual groups before)...");
            this.purgeAuthorizables(virtualGroupIds, session, installLog, true);
            installLog.addMessage(LOG, "Successfully purged virtual groups from repository: " + virtualGroupIds);
        }
        catch (Exception e) {
            installLog.addError(LOG, "Could not purge virtual groups", e);
        }
    }

    private void installMergedConfigurations(InstallationLogger installLog, AcConfiguration acConfiguration, String[] restrictedToPaths, Session session) throws ValueFormatException, RepositoryException, Exception {
        installLog.addVerboseMessage(LOG, "Starting installation of merged configurations...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Map<String, Set<AceBean>> repositoryDumpAceMap = null;
        LOG.debug("Building dump from repository (to compare delta with config to be installed)");
        repositoryDumpAceMap = this.dumpservice.createAclDumpMap(AcHelper.PATH_BASED_ORDER, AcHelper.ACE_ORDER_NONE, Collections.emptyList(), true, session).getAceDump();
        installLog.addMessage(LOG, "Retrieved existing ACLs from repository in " + PersistableInstallationLogger.msHumanReadable(stopWatch.getTime()) + (QueryHelper.hasQueryIndexForACLs(session) ? " using index for rep:ACL nodes" : " without additional index for rep:ACL (install oakindex package for better performance!)"));
        this.installAcConfiguration(acConfiguration, installLog, repositoryDumpAceMap, restrictedToPaths, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadyToStart() {
        Session session = null;
        boolean isReadyToStart = false;
        for (String configRootPath : this.configurationRootPaths) {
            try {
                session = this.repository.loginService(null, null);
                boolean thisConfigIsReadyToStart = !this.configFilesRetriever.getConfigFileContentFromNode(configRootPath, session).isEmpty();
                LOG.debug("Config {} is ready to start: {}", (Object)configRootPath, (Object)thisConfigIsReadyToStart);
                isReadyToStart |= thisConfigIsReadyToStart;
            }
            catch (Exception e) {
                LOG.warn("Could not retrieve config file content for root path " + configRootPath);
                boolean bl = false;
                return bl;
            }
            finally {
                if (session == null) continue;
                session.logout();
            }
        }
        return isReadyToStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String purgeACL(String path) {
        Session session = null;
        String message = "";
        boolean flag = true;
        try {
            session = this.repository.loginService(null, null);
            PurgeHelper.purgeAcl(session, path);
            session.save();
        }
        catch (Exception e) {
            flag = false;
            message = e.toString();
            LOG.error("Exception: ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        if (flag) {
            message = "Deleted AccessControlList of node: " + path;
            PersistableInstallationLogger installLog = new PersistableInstallationLogger();
            installLog.addMessage(LOG, "purge method: purgeACL()");
            installLog.addMessage(LOG, message);
            this.acHistoryService.persistAcePurgeHistory(installLog);
            return message;
        }
        return "Deletion of ACL failed! Reason:" + message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String purgeACLs(String path) {
        Session session = null;
        String message = "";
        boolean flag = true;
        try {
            session = this.repository.loginService(null, null);
            message = PurgeHelper.purgeACLs(session, path);
            PersistableInstallationLogger installLog = new PersistableInstallationLogger();
            installLog.addMessage(LOG, "purge method: purgeACLs()");
            installLog.addMessage(LOG, message);
            this.acHistoryService.persistAcePurgeHistory(installLog);
            session.save();
        }
        catch (Exception e) {
            LOG.error("Exception: ", (Throwable)e);
            flag = false;
            message = e.toString();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        if (flag) {
            return message;
        }
        return "Deletion of ACL failed! Reason:" + message;
    }

    @Override
    public String purgeAuthorizablesFromConfig() {
        ArrayList<String> resultMessages = new ArrayList<String>();
        for (String configRootPath : this.configurationRootPaths) {
            LOG.info("Purging authorizables for root path {}", (Object)configRootPath);
            resultMessages.add(this.purgeAuthorizablesFromConfig(configRootPath));
        }
        return StringUtils.join(resultMessages, (String)"\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String purgeAuthorizablesFromConfig(String configRootPath) {
        Session session = null;
        try {
            session = this.repository.loginService(null, null);
            PersistableInstallationLogger installLog = new PersistableInstallationLogger();
            installLog.addMessage(LOG, "*** Purging AC Tool configuraiton " + configRootPath + "...");
            Map<String, String> newestConfigurations = this.configFilesRetriever.getConfigFileContentFromNode(configRootPath, session);
            AcConfiguration acConfiguration = this.configurationMerger.getMergedConfigurations(newestConfigurations, installLog, this.configReader, session);
            installLog.addMessage(LOG, "Purging ACLs...");
            long startAclPurge = System.currentTimeMillis();
            acConfiguration.getAceConfig().clear();
            Map<String, Set<AceBean>> aceDump = this.dumpservice.createAclDumpMap(AcHelper.PATH_BASED_ORDER, AcHelper.ACE_ORDER_NONE, Collections.emptyList(), true, session).getAceDump();
            this.installAces(installLog, acConfiguration, aceDump, null, session);
            installLog.addMessage(LOG, "Purged ACLs for " + acConfiguration.getAuthorizablesConfig().size() + " authorizables in " + PersistableInstallationLogger.msHumanReadable(System.currentTimeMillis() - startAclPurge));
            installLog.addMessage(LOG, "Purging authorizables...");
            HashSet<String> authorizablesToPurge = new HashSet<String>();
            for (AuthorizableConfigBean authorizableConfigBean : acConfiguration.getAuthorizablesConfig()) {
                String authorizableId = authorizableConfigBean.getAuthorizableId();
                if (StringUtils.isNotBlank((CharSequence)authorizableConfigBean.getUnmanagedAcePathsRegex())) {
                    installLog.addMessage(LOG, "Not purging " + authorizableId + " since property unmanagedAcePathsRegex is configured");
                    continue;
                }
                if ("everyone".equals(authorizableId)) continue;
                authorizablesToPurge.add(authorizableId);
            }
            this.purgeAuthorizables(authorizablesToPurge, session, installLog, false);
            this.acHistoryService.persistAcePurgeHistory(installLog);
            String string = installLog.getMessageHistory();
            return string;
        }
        catch (Exception e) {
            LOG.error("Exception while purging all authorizable from config: {}", (Object)e, (Object)e);
            String string = "Could not purge authorizables from config " + configRootPath + ": " + e;
            return string;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String purgeAuthorizables(String[] authorizableIds) {
        PersistableInstallationLogger installLog = new PersistableInstallationLogger();
        Session session = null;
        try {
            session = this.repository.loginService(null, null);
            HashSet<String> authorizablesSet = new HashSet<String>(Arrays.asList(authorizableIds));
            this.purgeAuthorizables(authorizablesSet, session, installLog, true);
            this.acHistoryService.persistAcePurgeHistory(installLog);
        }
        catch (RepositoryException e) {
            installLog.addError(LOG, "Could not purge authorizables " + Arrays.asList(authorizableIds) + ": " + (Object)((Object)e), e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return installLog.getMessageHistory();
    }

    private void purgeAuthorizables(Set<String> authorizableIds, Session session, InstallationLogger installLog, boolean deleteAces) {
        StopWatch sw = new StopWatch();
        sw.start();
        try {
            if (deleteAces) {
                HashSet<String> principalIds = new HashSet<String>();
                Set<AclBean> aclBeans = QueryHelper.getAuthorizablesAcls(session, authorizableIds, principalIds);
                this.deleteAcesForPrincipalIds(session, installLog, principalIds, aclBeans);
            }
            UserManager userManager = AccessControlUtils.getUserManagerAutoSaveDisabled(session);
            ArrayList<Authorizable> authorizablesToDelete = new ArrayList<Authorizable>();
            for (String authorizableId : authorizableIds) {
                Authorizable authorizable = userManager.getAuthorizable(authorizableId);
                if (authorizable != null) {
                    authorizablesToDelete.add(authorizable);
                    continue;
                }
                installLog.addMessage(LOG, "Could not delete authorizable '" + authorizableId + "' because it does not exist");
            }
            this.sortAuthorizablesForDeletion(authorizablesToDelete);
            for (Authorizable authorizableToDelete : authorizablesToDelete) {
                this.deleteAuthorizable(installLog, authorizableToDelete);
            }
            session.save();
            sw.stop();
            String executionTime = PersistableInstallationLogger.msHumanReadable(sw.getTime());
            installLog.addMessage(LOG, "Purged " + authorizablesToDelete.size() + " authorizables in " + executionTime);
        }
        catch (Exception e) {
            installLog.addError(LOG, "Purging of authorizables failed: " + e, e);
        }
    }

    public void deleteAcesForPrincipalIds(Session session, InstallationLogger installLog, Set<String> principalIds, Set<AclBean> aclBeans) throws RepositoryException {
        StopWatch sw = new StopWatch();
        sw.start();
        AccessControlManager aMgr = session.getAccessControlManager();
        long aceCounter = 0L;
        for (AclBean aclBean : aclBeans) {
            if (aclBean == null) continue;
            JackrabbitAccessControlList acl = aclBean.getAcl();
            for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                String principalId = ace.getPrincipal().getName();
                if (!principalIds.contains(principalId)) continue;
                String parentNodePath = aclBean.getParentPath();
                acl.removeAccessControlEntry(ace);
                boolean aclEmpty = acl.isEmpty();
                if (!aclEmpty) {
                    aMgr.setPolicy(aclBean.getParentPath(), (AccessControlPolicy)acl);
                } else {
                    aMgr.removePolicy(aclBean.getParentPath(), (AccessControlPolicy)acl);
                }
                installLog.addVerboseMessage(LOG, "Path " + parentNodePath + ": Removed entry for '" + principalId + "' from ACL " + (aclEmpty ? " (and the now emtpy ACL itself)" : ""));
                ++aceCounter;
            }
        }
        sw.stop();
        String executionTime = PersistableInstallationLogger.msHumanReadable(sw.getTime());
        String resultMsg = aceCounter > 0L ? "Deleted " + aceCounter + " ACEs for " + principalIds.size() + " principals in " + executionTime : "Did not delete any ACEs";
        installLog.addMessage(LOG, resultMsg);
    }

    void sortAuthorizablesForDeletion(List<Authorizable> authorizablesToDelete) throws RepositoryException {
        int i = 0;
        block0: while (i < authorizablesToDelete.size()) {
            Authorizable currentAuthorizable = authorizablesToDelete.get(i);
            Iterator declaredMemberOfIt = currentAuthorizable.declaredMemberOf();
            LOG.trace("At index {}: {}", (Object)i, (Object)currentAuthorizable.getID());
            while (declaredMemberOfIt != null && declaredMemberOfIt.hasNext()) {
                Group groupOfAuthorizable = (Group)declaredMemberOfIt.next();
                int groupOfAuthorizableIndex = authorizablesToDelete.indexOf(groupOfAuthorizable);
                LOG.trace("  Is member of at index {}: {}", (Object)groupOfAuthorizableIndex, (Object)groupOfAuthorizable.getID());
                if (groupOfAuthorizableIndex <= -1 || groupOfAuthorizableIndex >= i) continue;
                LOG.trace("    Swap at index {} (groupOfAuthorizableIndex {}):", (Object)i, (Object)groupOfAuthorizableIndex);
                authorizablesToDelete.set(groupOfAuthorizableIndex, currentAuthorizable);
                authorizablesToDelete.set(i, (Authorizable)groupOfAuthorizable);
                i = groupOfAuthorizableIndex;
                continue block0;
            }
            ++i;
        }
    }

    private void deleteAuthorizable(InstallationLogger installLog, Authorizable authorizable) throws RepositoryException {
        try {
            ArrayList<String> removedFromGroups = new ArrayList<String>();
            Iterator declaredMemberOf = authorizable.declaredMemberOf();
            while (declaredMemberOf.hasNext()) {
                Group groupTheAuthorizableIsMemberOf = (Group)declaredMemberOf.next();
                if (!groupTheAuthorizableIsMemberOf.removeMember(authorizable)) continue;
                removedFromGroups.add(groupTheAuthorizableIsMemberOf.getID());
            }
            authorizable.remove();
            installLog.addVerboseMessage(LOG, "Deleted authorizable '" + authorizable.getID() + "'" + (!removedFromGroups.isEmpty() ? " and removed it from groups: " + StringUtils.join(removedFromGroups, (String)", ") : ""));
        }
        catch (RepositoryException e) {
            installLog.addError(LOG, "Error while deleting authorizable '" + authorizable.getID() + "': e=" + (Object)((Object)e), e);
        }
    }

    public List<String> getConfigurationRootPaths() {
        return this.configurationRootPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getCurrentConfigurationPaths() {
        Session session = null;
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        try {
            session = this.repository.loginService(null, null);
            for (String configRootPath : this.configurationRootPaths) {
                paths.addAll(this.configFilesRetriever.getConfigFileContentFromNode(configRootPath, session).keySet());
            }
        }
        catch (Exception e) {
            LOG.warn("Could not retrieve config file content for root paths {}: e={}", new Object[]{this.configurationRootPaths, e, e});
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return paths;
    }

    @Override
    public String getVersion() {
        String bundleVersion = FrameworkUtil.getBundle(AcInstallationServiceImpl.class).getVersion().toString();
        return bundleVersion;
    }

    @ObjectClassDefinition(name="AC Tool Installation Service", description="Service that installs groups & ACEs according to textual configuration files", id="biz.netcentric.cq.tools.actool.impl.AcInstallationServiceImpl")
    protected static @interface Configuration {
        @AttributeDefinition(name="Configuration path(s)", description="JCR path(s) where the config files reside (usually it's just one, can be multiple for multitenant setups)")
        public String[] configurationRootPaths() default {};
    }
}

