/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.authorizableinstaller.impl;

import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizablesConfig;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ImpersonationInstallerServiceImpl.class})
public class ImpersonationInstallerServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ImpersonationInstallerServiceImpl.class);

    public void setupImpersonation(User user, List<String> impersonationAllowedFor, AuthorizablesConfig authorizablesConfig, InstallationLogger installationLog) {
        try {
            List<String> impersonatorsToBeSet = this.expandImpersonatorsList(user.getID(), impersonationAllowedFor, authorizablesConfig);
            Impersonation impersonation = user.getImpersonation();
            List<String> currentImpersonators = this.collectCurrentImpersonators(impersonation);
            this.applyChanges(user, installationLog, impersonatorsToBeSet, impersonation, currentImpersonators);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Could not setup impersonation for user " + user + ": " + (Object)((Object)e), e);
        }
    }

    private void applyChanges(User user, InstallationLogger installationLog, List<String> impersonatorsToBeSet, Impersonation impersonation, List<String> currentImpersonators) throws RepositoryException {
        ArrayList<String> impersonatorsToAdd = new ArrayList<String>();
        impersonatorsToAdd.addAll(impersonatorsToBeSet);
        impersonatorsToAdd.removeAll(currentImpersonators);
        Iterator impersonatorsToAddIt = impersonatorsToAdd.iterator();
        while (impersonatorsToAddIt.hasNext()) {
            String impersonatorToAdd = (String)impersonatorsToAddIt.next();
            boolean success = impersonation.grantImpersonation((Principal)new PrincipalImpl(impersonatorToAdd));
            if (success) continue;
            impersonatorsToAddIt.remove();
            installationLog.addWarning(LOG, "Impersonator '" + impersonatorToAdd + "' can not be added to user " + user);
        }
        ArrayList<String> impersonatorsToRemove = new ArrayList<String>();
        impersonatorsToRemove.addAll(currentImpersonators);
        impersonatorsToRemove.removeAll(impersonatorsToBeSet);
        Iterator impersonatorsToRemoveIt = impersonatorsToRemove.iterator();
        while (impersonatorsToRemoveIt.hasNext()) {
            String impersonatorToRemove = (String)impersonatorsToRemoveIt.next();
            boolean success = impersonation.revokeImpersonation((Principal)new PrincipalImpl(impersonatorToRemove));
            if (success) continue;
            impersonatorsToRemoveIt.remove();
            installationLog.addWarning(LOG, "Impersonator '" + impersonatorToRemove + "' can not be removed from user " + user);
        }
        if (!impersonatorsToAdd.isEmpty() || !impersonatorsToRemove.isEmpty()) {
            installationLog.addVerboseMessage(LOG, "Adjusted impersonation for user " + user.getID() + ":");
            if (!impersonatorsToAdd.isEmpty()) {
                installationLog.addVerboseMessage(LOG, " Added impersonators=" + impersonatorsToAdd);
            }
            if (!impersonatorsToRemove.isEmpty()) {
                installationLog.addVerboseMessage(LOG, " Removed impersonators=" + impersonatorsToRemove);
            }
        }
    }

    private List<String> collectCurrentImpersonators(Impersonation impersonation) throws RepositoryException {
        PrincipalIterator principalIterator = impersonation.getImpersonators();
        ArrayList<String> impersonatorsCurrent = new ArrayList<String>();
        while (principalIterator.hasNext()) {
            impersonatorsCurrent.add(principalIterator.nextPrincipal().getName());
        }
        return impersonatorsCurrent;
    }

    private List<String> expandImpersonatorsList(String userAuthorizableId, List<String> impersonationAllowedFor, AuthorizablesConfig authorizablesConfig) {
        ArrayList<String> impersonatorsToBeSet = new ArrayList<String>();
        for (String impersonationAllowedForItem : impersonationAllowedFor) {
            if (StringUtils.indexOfAny((CharSequence)impersonationAllowedForItem, (char[])new char[]{'*', '?', '(', '|'}) > -1) {
                for (AuthorizableConfigBean authorizableConfigBean : authorizablesConfig) {
                    if (authorizableConfigBean.isGroup() || !authorizableConfigBean.getPrincipalName().matches(impersonationAllowedForItem) || authorizableConfigBean.getAuthorizableId().equals(userAuthorizableId)) continue;
                    impersonatorsToBeSet.add(authorizableConfigBean.getPrincipalName());
                }
                continue;
            }
            impersonatorsToBeSet.add(impersonationAllowedForItem);
        }
        return impersonatorsToBeSet;
    }
}

