/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configmodel;

import biz.netcentric.cq.tools.actool.configmodel.AutoCreateTestUsersConfig;
import biz.netcentric.cq.tools.actool.validators.GlobalConfigurationValidator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GlobalConfiguration {
    public static final String KEY_MIN_REQUIRED_VERSION = "minRequiredVersion";
    public static final String KEY_INSTALL_ACLS_INCREMENTALLY = "installAclsIncrementally";
    public static final String KEY_ALLOW_EXTERNAL_GROUP_NAMES_REGEX_OBSOLETE = "allowExternalGroupNamesRegEx";
    public static final String KEY_DEFAULT_UNMANAGED_EXTERNAL_ISMEMBEROF_REGEX = "defaultUnmanagedExternalIsMemberOfRegex";
    public static final String KEY_DEFAULT_UNMANAGED_EXTERNAL_MEMBERS_REGEX = "defaultUnmanagedExternalMembersRegex";
    public static final String KEY_DEFAULT_UNMANAGED_ACE_PATHS_REGEX = "defaultUnmanagedAcePathsRegex";
    public static final String KEY_ALLOW_CREATE_OF_UNMANAGED_RELATIONSHIPS = "allowCreateOfUnmanagedRelationships";
    public static final String KEY_ALLOW_EXTERNAL_GROUPS_IN_IS_MEMBER_OF = "allowExternalGroupsInIsMemberOf";
    public static final String KEY_AUTOCREATE_TEST_USERS = "autoCreateTestUsers";
    @Deprecated
    public static final String KEY_KEEP_EXISTING_MEMBERSHIPS_FOR_GROUP_NAMES_REGEX = "keepExistingMembershipsForGroupNamesRegEx";
    private String minRequiredVersion;
    private boolean installAclsIncrementally = true;
    private Pattern defaultUnmanagedExternalIsMemberOfRegex;
    private Pattern defaultUnmanagedExternalMembersRegex;
    private String defaultUnmanagedAcePathsRegex;
    private Boolean allowCreateOfUnmanagedRelationships = null;
    private Boolean allowExternalGroupsInIsMemberOf = null;
    private AutoCreateTestUsersConfig autoCreateTestUsersConfig;

    public GlobalConfiguration() {
    }

    public GlobalConfiguration(Map<String, ?> globalConfigMap) {
        if (globalConfigMap != null) {
            if (globalConfigMap.get(KEY_ALLOW_EXTERNAL_GROUP_NAMES_REGEX_OBSOLETE) != null) {
                throw new IllegalArgumentException("Configuration property allowExternalGroupNamesRegEx was renamed to keepExistingMembershipsForGroupNamesRegEx (since v2.0.0) - please adjust your configuration.");
            }
            this.setDefaultUnmanagedAcePathsRegex((String)globalConfigMap.get(KEY_DEFAULT_UNMANAGED_ACE_PATHS_REGEX));
            this.setDefaultUnmanagedExternalIsMemberOfRegex((String)globalConfigMap.get(KEY_DEFAULT_UNMANAGED_EXTERNAL_ISMEMBEROF_REGEX));
            this.setDefaultUnmanagedExternalMembersRegex((String)globalConfigMap.get(KEY_DEFAULT_UNMANAGED_EXTERNAL_MEMBERS_REGEX));
            String keepExistingMembershipsForGroupNamesRegEx = (String)globalConfigMap.get(KEY_KEEP_EXISTING_MEMBERSHIPS_FOR_GROUP_NAMES_REGEX);
            if (StringUtils.isNotBlank((CharSequence)keepExistingMembershipsForGroupNamesRegEx)) {
                if (this.defaultUnmanagedExternalIsMemberOfRegex == null && this.defaultUnmanagedExternalMembersRegex == null) {
                    this.setDefaultUnmanagedExternalIsMemberOfRegex(keepExistingMembershipsForGroupNamesRegEx);
                    this.setDefaultUnmanagedExternalMembersRegex(keepExistingMembershipsForGroupNamesRegEx);
                } else {
                    throw new IllegalArgumentException("Deprecated keepExistingMembershipsForGroupNamesRegEx cannot be used together with defaultUnmanagedExternalIsMemberOfRegex or defaultUnmanagedExternalMembersRegex");
                }
            }
            if (globalConfigMap.containsKey(KEY_ALLOW_CREATE_OF_UNMANAGED_RELATIONSHIPS)) {
                this.setAllowCreateOfUnmanagedRelationships(Boolean.valueOf(globalConfigMap.get(KEY_ALLOW_CREATE_OF_UNMANAGED_RELATIONSHIPS).toString()));
            }
            this.setMinRequiredVersion((String)globalConfigMap.get(KEY_MIN_REQUIRED_VERSION));
            if (globalConfigMap.containsKey(KEY_INSTALL_ACLS_INCREMENTALLY)) {
                this.setInstallAclsIncrementally(Boolean.valueOf(globalConfigMap.get(KEY_INSTALL_ACLS_INCREMENTALLY).toString()));
            }
            if (globalConfigMap.containsKey(KEY_AUTOCREATE_TEST_USERS)) {
                this.autoCreateTestUsersConfig = new AutoCreateTestUsersConfig((Map)globalConfigMap.get(KEY_AUTOCREATE_TEST_USERS));
            }
            if (globalConfigMap.containsKey(KEY_ALLOW_EXTERNAL_GROUPS_IN_IS_MEMBER_OF)) {
                this.setAllowExternalGroupsInIsMemberOf(Boolean.valueOf(globalConfigMap.get(KEY_ALLOW_EXTERNAL_GROUPS_IN_IS_MEMBER_OF).toString()));
            }
        }
    }

    public void merge(GlobalConfiguration otherGlobalConfig) {
        if (otherGlobalConfig.getDefaultUnmanagedAcePathsRegex() != null) {
            if (this.defaultUnmanagedAcePathsRegex == null) {
                this.defaultUnmanagedAcePathsRegex = otherGlobalConfig.getDefaultUnmanagedAcePathsRegex();
            } else {
                throw new IllegalArgumentException("Duplicate config for defaultUnmanagedAcePathsRegex");
            }
        }
        if (otherGlobalConfig.getDefaultUnmanagedExternalIsMemberOfRegex() != null) {
            if (this.defaultUnmanagedExternalIsMemberOfRegex == null) {
                this.defaultUnmanagedExternalIsMemberOfRegex = otherGlobalConfig.getDefaultUnmanagedExternalIsMemberOfRegex();
            } else {
                throw new IllegalArgumentException("Duplicate config for defaultUnmanagedExternalIsMemberOfRegex");
            }
        }
        if (otherGlobalConfig.getDefaultUnmanagedExternalMembersRegex() != null) {
            if (this.defaultUnmanagedExternalMembersRegex == null) {
                this.defaultUnmanagedExternalMembersRegex = otherGlobalConfig.getDefaultUnmanagedExternalMembersRegex();
            } else {
                throw new IllegalArgumentException("Duplicate config for defaultUnmanagedExternalMembersRegex");
            }
        }
        if (otherGlobalConfig.getAllowCreateOfUnmanagedRelationships() != null) {
            if (this.allowCreateOfUnmanagedRelationships == null) {
                this.allowCreateOfUnmanagedRelationships = otherGlobalConfig.getAllowCreateOfUnmanagedRelationships();
            } else {
                throw new IllegalArgumentException("Duplicate config for allowCreateOfUnmanagedRelationships");
            }
        }
        if (otherGlobalConfig.getMinRequiredVersion() != null) {
            if (this.minRequiredVersion == null) {
                this.minRequiredVersion = otherGlobalConfig.getMinRequiredVersion();
            } else {
                String string = this.minRequiredVersion = GlobalConfigurationValidator.versionCompare(otherGlobalConfig.getMinRequiredVersion(), this.minRequiredVersion) > 0 ? otherGlobalConfig.getMinRequiredVersion() : this.minRequiredVersion;
            }
        }
        if (!otherGlobalConfig.installAclsIncrementally) {
            this.installAclsIncrementally = false;
        }
        if (otherGlobalConfig.getAutoCreateTestUsersConfig() != null) {
            if (this.autoCreateTestUsersConfig == null) {
                this.autoCreateTestUsersConfig = otherGlobalConfig.getAutoCreateTestUsersConfig();
            } else {
                throw new IllegalArgumentException("Duplicate config for autoCreateTestUsers");
            }
        }
        if (otherGlobalConfig.getAllowExternalGroupsInIsMemberOf() != null) {
            if (this.allowExternalGroupsInIsMemberOf == null) {
                this.allowExternalGroupsInIsMemberOf = otherGlobalConfig.getAllowExternalGroupsInIsMemberOf();
            } else {
                throw new IllegalArgumentException("Duplicate config for allowExternalGroupsInIsMemberOf");
            }
        }
    }

    public String getMinRequiredVersion() {
        return this.minRequiredVersion;
    }

    public void setMinRequiredVersion(String requiredMinVersion) {
        this.minRequiredVersion = requiredMinVersion;
    }

    public boolean getInstallAclsIncrementally() {
        return this.installAclsIncrementally;
    }

    public void setInstallAclsIncrementally(boolean installAclsIncrementally) {
        this.installAclsIncrementally = installAclsIncrementally;
    }

    public Pattern getDefaultUnmanagedExternalIsMemberOfRegex() {
        return this.defaultUnmanagedExternalIsMemberOfRegex;
    }

    public void setDefaultUnmanagedExternalIsMemberOfRegex(String defaultUnmanagedExternalIsMemberOfRegex) {
        this.defaultUnmanagedExternalIsMemberOfRegex = GlobalConfiguration.stringToRegex(defaultUnmanagedExternalIsMemberOfRegex);
    }

    public Pattern getDefaultUnmanagedExternalMembersRegex() {
        return this.defaultUnmanagedExternalMembersRegex;
    }

    public void setDefaultUnmanagedExternalMembersRegex(String defaultUnmanagedExternalMembersRegex) {
        this.defaultUnmanagedExternalMembersRegex = GlobalConfiguration.stringToRegex(defaultUnmanagedExternalMembersRegex);
    }

    public String getDefaultUnmanagedAcePathsRegex() {
        return this.defaultUnmanagedAcePathsRegex;
    }

    public void setDefaultUnmanagedAcePathsRegex(String defaultUnmanagedAcePathsRegex) {
        this.defaultUnmanagedAcePathsRegex = defaultUnmanagedAcePathsRegex;
    }

    public Boolean getAllowCreateOfUnmanagedRelationships() {
        return this.allowCreateOfUnmanagedRelationships;
    }

    public void setAllowCreateOfUnmanagedRelationships(Boolean allowCreateOfUnmanagedRelationships) {
        this.allowCreateOfUnmanagedRelationships = allowCreateOfUnmanagedRelationships;
    }

    static Pattern stringToRegex(String regex) {
        return StringUtils.isNotBlank((CharSequence)regex) ? Pattern.compile(regex) : null;
    }

    public AutoCreateTestUsersConfig getAutoCreateTestUsersConfig() {
        return this.autoCreateTestUsersConfig;
    }

    public Boolean getAllowExternalGroupsInIsMemberOf() {
        return this.allowExternalGroupsInIsMemberOf;
    }

    public void setAllowExternalGroupsInIsMemberOf(Boolean allowExternalGroupsInIsMemberOf) {
        this.allowExternalGroupsInIsMemberOf = allowExternalGroupsInIsMemberOf;
    }
}

