/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configmodel;

import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.configmodel.AcesConfig;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizablesConfig;
import biz.netcentric.cq.tools.actool.configmodel.GlobalConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcConfiguration {
    public static final Logger LOG = LoggerFactory.getLogger(AcConfiguration.class);
    private GlobalConfiguration globalConfiguration;
    private AuthorizablesConfig authorizablesConfig;
    private AcesConfig aceBeansConfig;
    private Set<String> obsoleteAuthorizables = new HashSet<String>();
    private List<AuthorizableConfigBean> virtualGroups = new ArrayList<AuthorizableConfigBean>();

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public AuthorizablesConfig getAuthorizablesConfig() {
        return this.authorizablesConfig;
    }

    public void setAuthorizablesConfig(AuthorizablesConfig authorizablesSet) {
        this.authorizablesConfig = authorizablesSet;
    }

    public AcesConfig getAceConfig() {
        return this.aceBeansConfig;
    }

    public void setAceConfig(AcesConfig aceBeansSet) {
        this.aceBeansConfig = aceBeansSet;
        this.ensureAceBeansHaveCorrectPrincipalNameSet();
    }

    public void ensureAceBeansHaveCorrectPrincipalNameSet() {
        if (this.authorizablesConfig == null) {
            throw new IllegalStateException("authorizablesConfig must be set before setAceConfig() is called");
        }
        LOG.debug("Ensuring ACE Beans have correct principal name set...");
        for (AceBean aceBean : this.aceBeansConfig) {
            String authorizableId = aceBean.getAuthorizableId();
            String principalName = this.authorizablesConfig.getPrincipalNameForAuthorizableId(authorizableId);
            if (StringUtils.isNotBlank((CharSequence)principalName)) {
                aceBean.setPrincipalName(principalName);
                continue;
            }
            LOG.debug("Setting principal name for ACE at {} to authorizable id '{}' as principal name cannot be mapped from authorizable bean", (Object)aceBean.getJcrPath(), (Object)authorizableId);
            aceBean.setPrincipalName(authorizableId);
        }
    }

    public Set<String> getObsoleteAuthorizables() {
        return this.obsoleteAuthorizables;
    }

    public void setObsoleteAuthorizables(Set<String> obsoleteAuthorizables) {
        this.obsoleteAuthorizables = obsoleteAuthorizables;
    }

    public List<AuthorizableConfigBean> getVirtualGroups() {
        return this.virtualGroups;
    }

    public void setVirtualGroups(List<AuthorizableConfigBean> virtualGroups) {
        this.virtualGroups = virtualGroups;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("globalConfiguration", (Object)this.globalConfiguration).append("authorizablesConfig", (Object)this.authorizablesConfig).append("aceBeansConfig", (Object)this.aceBeansConfig).append("obsoleteAuthorizables", this.obsoleteAuthorizables).append("virtualGroups", this.virtualGroups).toString();
    }
}

