/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configreader;

import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.service.cm.ConfigurationPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class YamlConfigurationAdminPluginScalarConstructor
extends Constructor {
    public static final Tag TAG = new Tag("!CONFIGADMIN");
    private static final Logger LOG = LoggerFactory.getLogger(YamlConfigurationAdminPluginScalarConstructor.class);
    static final String KEY = "myKey";
    private final ConfigurationPlugin interpolationPlugin;
    private final InstallationLogger installLog;

    public YamlConfigurationAdminPluginScalarConstructor(InstallationLogger installLog, ConfigurationPlugin interpolationPlugin) {
        this.yamlConstructors.put(TAG, new ConstructYamlConfigurationAdminPlugin());
        this.interpolationPlugin = interpolationPlugin;
        this.installLog = installLog;
    }

    private String resolvePlaceholder(String scalar) {
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put(KEY, scalar);
        try {
            this.installLog.addMessage(LOG, "Using ConfigAdminPlugin to resolve '" + scalar + "'");
            this.interpolationPlugin.modifyConfiguration(null, dictionary);
            return (String)((Dictionary)dictionary).get(KEY);
        }
        catch (Exception e) {
            throw new YAMLException("Could not resolve scalar: " + scalar + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private class ConstructYamlConfigurationAdminPlugin
    extends AbstractConstruct {
        private ConstructYamlConfigurationAdminPlugin() {
        }

        public Object construct(Node node) {
            String value = YamlConfigurationAdminPluginScalarConstructor.this.constructScalar((ScalarNode)node);
            return YamlConfigurationAdminPluginScalarConstructor.this.resolvePlaceholder(value);
        }
    }
}

