/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.source;

import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpSource
implements LessSource {
    private final URL url;
    private final int port;
    private final String encoding;
    private Date lastModificationDate;

    public FtpSource(URL url) {
        this(url, Charset.defaultCharset().toString());
    }

    public FtpSource(URL url, String encoding) {
        this.url = url;
        this.port = url.getPort() != -1 ? url.getPort() : 21;
        this.encoding = encoding;
    }

    public String getPath() {
        return this.url.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getContent() {
        FTPClient connection = this.connect();
        String content = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (!connection.retrieveFile(this.url.getPath(), (OutputStream)outputStream)) {
                throw new SourceException(String.format("Cannot download source \"%s\" file, reason: %s", this.url, connection.getReplyString()));
            }
            content = outputStream.toString(this.encoding);
        }
        catch (IOException e) {
            throw new SourceException(String.format("Cannot download source \"%s\" file", this.url), e);
        }
        finally {
            FtpSource.disconnect(connection);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        this.lastModificationDate = this.getModificationDate();
        return content;
    }

    public Date getLastModificationDate() {
        if (this.lastModificationDate != null) {
            return (Date)this.lastModificationDate.clone();
        }
        return this.getModificationDate();
    }

    private Date getModificationDate() {
        FTPFile file = this.getFile();
        if (file.getTimestamp() == null) {
            return new Date();
        }
        return file.getTimestamp().getTime();
    }

    private FTPFile getFile() {
        FTPFile[] files;
        FTPClient connection = this.connect();
        try {
            files = connection.listFiles(this.url.getPath());
        }
        catch (IOException e) {
            throw new SourceException(String.format("Cannot fetch files list from server during fetching file \"%s\" metadata", this.url), e);
        }
        if (files.length == 0) {
            throw new SourceException(String.format("Source file \"%s\" does not exist", this.url));
        }
        FtpSource.disconnect(connection);
        return files[0];
    }

    private FTPClient connect() {
        FTPClient connection = new FTPClient();
        try {
            connection.setAutodetectUTF8(true);
            connection.connect(this.url.getHost(), this.port);
            connection.enterLocalActiveMode();
            if (!connection.login("anonymous", "gabrys.biz Extended LessCSS Compiler")) {
                throw new SourceException(String.format("Cannot login as anonymous user, reason %s", connection.getReplyString()));
            }
            if (!FTPReply.isPositiveCompletion((int)connection.getReplyCode())) {
                throw new SourceException(String.format("Cannot download source \"%s\", reason: %s", this.url, connection.getReplyString()));
            }
            connection.enterLocalPassiveMode();
            connection.setFileType(2);
        }
        catch (IOException e) {
            FtpSource.disconnect(connection);
            throw new SourceException(String.format("Cannot download source \"%s\"", this.url), e);
        }
        return connection;
    }

    private static void disconnect(FTPClient connection) {
        try {
            connection.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

