/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.spring;

import aQute.lib.osgi.AnalyzerPlugin;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class SpringComponent
implements AnalyzerPlugin {
    static Transformer transformer;
    static Pattern SPRING_SOURCE;
    static Pattern QN;

    public static Set analyze(InputStream in) throws Exception {
        if (transformer == null) {
            TransformerFactory tf = TransformerFactory.newInstance();
            StreamSource source = new StreamSource(SpringComponent.class.getResourceAsStream("extract.xsl"));
            transformer = tf.newTransformer(source);
        }
        HashSet<CharSequence> refers = new HashSet<CharSequence>();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamResult r = new StreamResult(bout);
        StreamSource s = new StreamSource(in);
        transformer.transform(s, r);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        bout.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                String[] parts = line.split("\\s*,\\s*");
                for (int i = 0; i < parts.length; ++i) {
                    int n = parts[i].lastIndexOf(46);
                    if (n <= 0) continue;
                    refers.add(parts[i].subSequence(0, n));
                }
            }
            line = br.readLine();
        }
        br.close();
        return refers;
    }

    public void analyzeJar(Processor processor, Jar jar, String prefix, Map classSpace, Map contained, Map referred, Map uses) throws Exception {
        Map dir = (Map)jar.getDirectories().get("META-INF/spring");
        if (dir == null || dir.isEmpty()) {
            return;
        }
        for (Map.Entry entry : dir.entrySet()) {
            String path = (String)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            if (!SPRING_SOURCE.matcher(path).matches()) continue;
            try {
                InputStream in = resource.openInputStream();
                Set set = SpringComponent.analyze(in);
                in.close();
                for (String pack : set) {
                    if (!QN.matcher(pack).matches()) {
                        processor.warning("Package does not seem a package in spring resource (" + path + "): " + pack);
                    }
                    if (referred.containsKey(pack)) continue;
                    referred.put(pack, new LinkedHashMap());
                }
            }
            catch (Exception e) {
                processor.error("Unexpected exception in processing spring resources(" + path + "): " + e);
            }
        }
    }

    static {
        SPRING_SOURCE = Pattern.compile("META-INF/spring/.*\\.xml");
        QN = Pattern.compile("[_A-Za-z$][_A-Za-z0-9$]*(\\.[_A-Za-z$][_A-Za-z0-9$]*)*");
    }
}

