/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.qtokens;

import java.util.ArrayList;
import java.util.List;

public class QuotedTokenizer {
    String string;
    int index = 0;
    String separators;
    boolean returnTokens;
    boolean ignoreWhiteSpace = true;
    String peek;
    char separator;

    public QuotedTokenizer(String string, String separators, boolean returnTokens) {
        if (string == null) {
            throw new IllegalArgumentException("string argument must be not null");
        }
        this.string = string;
        this.separators = separators;
        this.returnTokens = returnTokens;
    }

    public QuotedTokenizer(String string, String separators) {
        this(string, separators, false);
    }

    public String nextToken(String separators) {
        String result;
        this.separator = '\u0000';
        if (this.peek != null) {
            String tmp = this.peek;
            this.peek = null;
            return tmp;
        }
        if (this.index == this.string.length()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        block3: while (this.index < this.string.length()) {
            char c;
            if (Character.isWhitespace(c = this.string.charAt(this.index++))) {
                if (this.index != this.string.length()) continue;
                break;
            }
            if (separators.indexOf(c) >= 0) {
                if (this.returnTokens) {
                    this.peek = Character.toString(c);
                    break;
                }
                this.separator = c;
                break;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    this.quotedString(sb, c);
                    continue block3;
                }
            }
            sb.append(c);
        }
        if ((result = sb.toString().trim()).length() == 0 && this.index == this.string.length()) {
            return null;
        }
        return result;
    }

    public String nextToken() {
        return this.nextToken(this.separators);
    }

    private void quotedString(StringBuffer sb, char c) {
        char quote = c;
        while (this.index < this.string.length() && (c = this.string.charAt(this.index++)) != quote) {
            if (c == '\\' && this.index < this.string.length() && this.string.charAt(this.index + 1) == quote) {
                c = this.string.charAt(this.index++);
            }
            sb.append(c);
        }
    }

    public String[] getTokens() {
        return this.getTokens(0);
    }

    private String[] getTokens(int cnt) {
        String token = this.nextToken();
        if (token == null) {
            return new String[cnt];
        }
        String[] result = this.getTokens(cnt + 1);
        result[cnt] = token;
        return result;
    }

    public char getSeparator() {
        return this.separator;
    }

    public List getTokenSet() {
        ArrayList<String> list = new ArrayList<String>();
        String token = this.nextToken();
        while (token != null) {
            list.add(token);
            token = this.nextToken();
        }
        return list;
    }
}

