/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.header;

import aQute.lib.qtokens.QuotedTokenizer;
import aQute.lib.reporter.Reporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class OSGiHeader {
    public static Map parseHeader(String value) {
        return OSGiHeader.parseHeader(value, null);
    }

    public static Map parseHeader(String value, Reporter logger) {
        if (value == null || value.trim().length() == 0) {
            return new HashMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        char del = '\u0000';
        do {
            boolean hadAttribute = false;
            HashMap<String, String> clause = new HashMap<String, String>();
            ArrayList<String> aliases = new ArrayList<String>();
            String name = qt.nextToken();
            del = qt.getSeparator();
            if (name == null || name.length() == 0) {
                if (logger != null && logger.isPedantic()) {
                    logger.warning("Empty clause, usually caused by repeating a comma without any name field or by having spaces after the backslash of a property file: " + value);
                }
                if (name != null) continue;
                break;
            }
            name = name.trim();
            aliases.add(name);
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute && logger != null) {
                        logger.error("Header contains name field after attribute or directive: " + adname + " from " + value + ". Name fields must be consecutive, separated by a ';' like a;b;c;x=3;y=4");
                    }
                    if (adname == null || adname.length() <= 0) continue;
                    aliases.add(adname.trim());
                    continue;
                }
                String advalue = qt.nextToken();
                if (clause.containsKey(adname) && logger != null && logger.isPedantic()) {
                    logger.warning("Duplicate attribute/directive name " + adname + " in " + value + ". This attribute/directive will be ignored");
                }
                if (advalue == null) {
                    if (logger != null) {
                        logger.error("No value after '=' sign for attribute " + adname);
                    }
                    advalue = "";
                }
                clause.put(adname.trim(), advalue.trim());
                del = qt.getSeparator();
                hadAttribute = true;
            }
            for (String clauseName : aliases) {
                if (result.containsKey(clauseName)) {
                    if (logger == null || !logger.isPedantic()) continue;
                    logger.warning("Duplicate name " + clauseName + " used in header: '" + clauseName + "'. Duplicate names in one clause not supported in Bnd.");
                    continue;
                }
                result.put(clauseName, clause);
            }
        } while (del == ',');
        return result;
    }
}

