/* Copyright 2006 aQute SARL 
 * Licensed under the Apache License, Version 2.0, see http://www.apache.org/licenses/LICENSE-2.0 */
package aQute.lib.osgi;

import java.io.*;
import java.util.Enumeration;
import java.util.regex.*;
import java.util.zip.*;

public class ZipResource implements Resource {
	ZipFile		zip;

	ZipEntry	entry;

	ZipResource(ZipFile zip, ZipEntry entry) {
		this.zip = zip;
		this.entry = entry;
	}

	public InputStream openInputStream() throws IOException {
		return zip.getInputStream(entry);
	}

	public String toString() {
		return ":" + entry.getName() + ":";
	}

	public static void build(Jar jar, File file) throws ZipException,
			IOException {
		build(jar, file, null);
	}

	public static void build(Jar jar, File file, Pattern pattern)
			throws ZipException, IOException {

		try {
			ZipFile zip = new ZipFile(file);
			nextEntry: for (Enumeration e = zip.entries(); e.hasMoreElements();) {
				ZipEntry entry = (ZipEntry) e.nextElement();
				if (pattern != null) {
					Matcher m = pattern.matcher(entry.getName());
					if (!m.matches())
						continue nextEntry;
				}
				if (!entry.isDirectory())
					jar.putResource(
							entry.getName(),
							new ZipResource(zip, entry));
			}
		}
		catch (FileNotFoundException e) {
			throw new IllegalArgumentException("Problem opening JAR: "
					+ file.getAbsolutePath());
		}
	}

	public void write(OutputStream out) throws IOException {
		FileResource.copy(this, out);
	}

}
