/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.testing.plugin;

import aQute.bnd.build.Workspace;
import aQute.bnd.maven.lib.configuration.Bndruns;
import aQute.bnd.maven.lib.resolve.DependencyResolver;
import aQute.bnd.repository.fileset.FileSetRepository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.glob.Glob;
import aQute.service.reporter.Reporter;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import java.io.File;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.osgi.service.resolver.ResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="testing", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class TestingMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(TestingMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySession;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private Bndruns bndruns = new Bndruns();
    @Parameter(defaultValue="${project.build.directory}/test", readonly=true)
    private File cwd;
    @Parameter(defaultValue="${project.build.directory}/test-reports", readonly=true)
    private File reportsDir;
    @Parameter(defaultValue="${testing.select}", readonly=true)
    private File testingSelect;
    @Parameter(defaultValue="${testing}", readonly=true)
    private String testing;
    @Parameter(property="test")
    private String test;
    @Parameter(required=false)
    private List<File> bundles;
    @Parameter(defaultValue="true")
    private boolean useMavenDependencies;
    @Parameter(defaultValue="false")
    private boolean resolve;
    @Parameter(defaultValue="true")
    private boolean reportOptional;
    @Parameter(defaultValue="true")
    private boolean failOnChanges;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    private int errors = 0;
    @Component
    private RepositorySystem system;
    @Component
    private ProjectDependenciesResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests) {
            return;
        }
        try {
            DependencyResolver dependencyResolver = new DependencyResolver(this.project, this.repositorySession, this.resolver, this.system);
            FileSetRepository fileSetRepository = dependencyResolver.getFileSetRepository(this.project.getName(), this.bundles, this.useMavenDependencies);
            if (this.testingSelect != null) {
                logger.info("Using selected testing file {}", (Object)this.testingSelect);
                this.testing(this.testingSelect, fileSetRepository);
            } else {
                Glob g = new Glob(this.testing == null ? "*" : this.testing);
                logger.info("Matching glob {}", (Object)g);
                for (File runFile : this.bndruns.getFiles(this.project.getBasedir(), "*.bndrun")) {
                    if (g.matcher((CharSequence)runFile.getName()).matches()) {
                        this.testing(runFile, fileSetRepository);
                        continue;
                    }
                    logger.info("Skipping {}", (Object)g);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.errors > 0) {
            throw new MojoExecutionException(this.errors + " errors found");
        }
    }

    private List<String> getTests() {
        logger.debug("getTests: {}", (Object)this.test);
        if (this.test == null || this.test.trim().isEmpty()) {
            return null;
        }
        return Strings.split((String)this.test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testing(File runFile, FileSetRepository fileSetRepository) throws Exception {
        if (!runFile.exists()) {
            logger.error("Could not find bnd run file {}", (Object)runFile);
            ++this.errors;
            return;
        }
        String bndrun = this.getNamePart(runFile);
        File workingDir = new File(this.cwd, bndrun);
        File cnf = new File(workingDir, "cnf");
        IO.mkdirs((File)cnf);
        try (Bndrun run = Bndrun.createBndrun(null, (File)runFile);){
            run.setBase(workingDir);
            Workspace workspace = run.getWorkspace();
            workspace.setBuildDir(cnf);
            workspace.setOffline(this.session.getSettings().isOffline());
            workspace.addBasicPlugin((Object)fileSetRepository);
            for (RepositoryPlugin repo : workspace.getRepositories()) {
                repo.list(null);
            }
            run.getInfo((Reporter)workspace);
            this.report(run);
            if (!run.isOk()) {
                return;
            }
            if (this.resolve) {
                try {
                    String runBundles = run.resolve(this.failOnChanges, false);
                    if (!run.isOk()) {
                        return;
                    }
                    run.setProperty("-runbundles", runBundles);
                }
                catch (ResolutionException re) {
                    logger.error(ResolveProcess.format((ResolutionException)re, (boolean)this.reportOptional));
                    throw re;
                }
                finally {
                    this.report(run);
                }
            }
            try {
                run.test(new File(this.reportsDir, bndrun), this.getTests());
            }
            finally {
                this.report(run);
            }
        }
    }

    private String getNamePart(File runFile) {
        String nameExt = runFile.getName();
        int pos = nameExt.lastIndexOf(46);
        return pos > 0 ? nameExt.substring(0, pos) : nameExt;
    }

    private void report(Bndrun run) {
        for (String warning : run.getWarnings()) {
            logger.warn("Warning : {}", (Object)warning);
        }
        for (String error : run.getErrors()) {
            logger.error("Error   : {}", (Object)error);
            ++this.errors;
        }
    }
}

