/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.indexer.plugin;

import aQute.bnd.maven.lib.configuration.FileTree;
import aQute.bnd.osgi.repository.SimpleIndexer;
import aQute.lib.io.IO;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="local-index", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class LocalIndexerMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(LocalIndexerMojo.class);
    @Parameter(property="bnd.indexer.input.dir", required=true)
    private File inputDir;
    @Parameter(property="bnd.indexer.output.file", defaultValue="${project.build.directory}/index.xml")
    private File outputFile;
    @Parameter(property="bnd.indexer.base.file")
    private File baseFile;
    @Parameter
    private FileTree indexFiles = new FileTree();
    @Parameter(property="bnd.indexer.include.gzip", defaultValue="true")
    private boolean includeGzip;
    @Parameter(property="bnd.indexer.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="bnd.indexer.absolute", defaultValue="false")
    private boolean absolute;
    @Parameter(property="bnd.indexer.name", defaultValue="${project.artifactId}")
    private String indexName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        if (this.baseFile == null) {
            this.baseFile = this.outputFile.getParentFile();
        }
        if (!this.inputDir.isDirectory()) {
            throw new MojoExecutionException("inputDir does not refer to a directory");
        }
        logger.debug("Indexing dependencies in folder: {}", (Object)this.inputDir.getAbsolutePath());
        logger.debug("Outputting index to: {}", (Object)this.outputFile.getAbsolutePath());
        logger.debug("Producing additional gzip index: {}", (Object)this.includeGzip);
        if (this.absolute) {
            logger.debug("URI paths will be absolute");
        } else {
            logger.debug("URI paths will be relative to: {}", (Object)this.baseFile);
        }
        try {
            List toIndex = this.indexFiles.getFiles(this.inputDir, new String[]{"**/*.jar"});
            if (this.absolute) {
                toIndex = toIndex.stream().map(f -> f.toPath().normalize().toFile()).collect(Collectors.toList());
            }
            logger.debug("Included files: {}", (Object)toIndex);
            IO.mkdirs((File)this.outputFile.getParentFile());
            SimpleIndexer simpleIndexer = new SimpleIndexer().files(toIndex);
            if (!this.absolute) {
                simpleIndexer.base(this.baseFile.toURI());
            }
            simpleIndexer.name(this.indexName).index(this.outputFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.includeGzip) {
            File gzipOutputFile = new File(this.outputFile.getAbsolutePath() + ".gz");
            try (GZIPOutputStream out = new GZIPOutputStream(IO.outputStream((File)gzipOutputFile));){
                IO.copy((File)this.outputFile, (OutputStream)out);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to create the gzipped output file", e);
            }
        }
    }
}

