/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.indexer.plugin;

import aQute.bnd.maven.lib.resolve.DependencyResolver;
import aQute.bnd.maven.lib.resolve.LocalURLs;
import aQute.bnd.maven.lib.resolve.PostProcessor;
import aQute.bnd.maven.lib.resolve.RemotePostProcessor;
import aQute.bnd.maven.lib.resolve.Scope;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.repository.XMLResourceGenerator;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.CapabilityBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.lib.io.IO;
import aQute.libg.cryptography.SHA256;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.resolution.ArtifactResult;
import org.osgi.service.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="index", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class IndexerMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(IndexerMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(property="bnd.indexer.output.file", defaultValue="${project.build.directory}/index.xml")
    private File outputFile;
    @Parameter(property="bnd.indexer.localURLs", defaultValue="FORBIDDEN")
    private LocalURLs localURLs;
    @Parameter(property="bnd.indexer.includeTransitive", defaultValue="true")
    private boolean includeTransitive;
    @Parameter(property="bnd.indexer.includeJar", defaultValue="false")
    private boolean includeJar;
    @Parameter(property="bnd.indexer.add.mvn.urls", defaultValue="false")
    private boolean addMvnURLs;
    @Parameter(property="bnd.indexer.scopes", defaultValue="compile,runtime")
    private Set<Scope> scopes;
    @Parameter(property="bnd.indexer.include.gzip", defaultValue="true")
    private boolean includeGzip;
    @Parameter(property="bnd.indexer.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="bnd.indexer.attach", defaultValue="true")
    private boolean attach;
    @Parameter(property="altReleaseDeploymentRepository")
    private String altReleaseDeploymentRepository;
    @Parameter(property="altSnapshotDeploymentRepository")
    private String altSnapshotDeploymentRepository;
    @Parameter(property="bnd.indexer.name", defaultValue="${project.artifactId}")
    private String indexName;
    @Parameter(property="altDeploymentRepository")
    private String altDeploymentRepository;
    @Component
    private RepositorySystem system;
    @Component
    private ProjectDependenciesResolver resolver;
    @Component
    private MetadataReader metadataReader;
    @Component
    private MavenProjectHelper projectHelper;
    private boolean fail;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        logger.debug("Indexing dependencies with scopes: {}", this.scopes);
        logger.debug("Including Transitive dependencies: {}", (Object)this.includeTransitive);
        logger.debug("Local file URLs permitted: {}", (Object)this.localURLs);
        logger.debug("Adding mvn: URLs as alternative content: {}", (Object)this.addMvnURLs);
        LinkedHashMap<String, ArtifactRepository> repositories = new LinkedHashMap<String, ArtifactRepository>();
        for (ArtifactRepository artifactRepository : this.project.getRemoteArtifactRepositories()) {
            logger.debug("Located an artifact repository {}", (Object)artifactRepository.getId());
            repositories.put(artifactRepository.getId(), artifactRepository);
        }
        this.addDeploymentRepo(repositories, this.project.getDistributionManagementArtifactRepository());
        this.addDeploymentRepo(repositories, this.parseAltDistRepo(this.altReleaseDeploymentRepository, true, false));
        this.addDeploymentRepo(repositories, this.parseAltDistRepo(this.altSnapshotDeploymentRepository, false, true));
        this.addDeploymentRepo(repositories, this.parseAltDistRepo(this.altDeploymentRepository, true, true));
        DependencyResolver dependencyResolver = new DependencyResolver(this.project, this.session, this.resolver, this.system, this.scopes, this.includeTransitive, (PostProcessor)new RemotePostProcessor(this.session, this.system, this.metadataReader, this.localURLs));
        Map dependencies = dependencyResolver.resolveAgainstRepos(repositories.values());
        RepositoryURLResolver repositoryURLResolver = new RepositoryURLResolver(repositories);
        MavenURLResolver mavenURLResolver = new MavenURLResolver();
        ResourcesRepository resourcesRepository = new ResourcesRepository();
        XMLResourceGenerator xmlResourceGenerator = new XMLResourceGenerator();
        logger.debug("Indexing artifacts: {}", dependencies.keySet());
        try {
            File current;
            IO.mkdirs((File)this.outputFile.getParentFile());
            for (Map.Entry entry : dependencies.entrySet()) {
                File file = (File)entry.getKey();
                ResourceBuilder resourceBuilder = new ResourceBuilder();
                resourceBuilder.addFile((File)entry.getKey(), repositoryURLResolver.resolver(file, (ArtifactResult)entry.getValue()));
                if (this.addMvnURLs) {
                    CapabilityBuilder c = new CapabilityBuilder("osgi.content");
                    c.addAttribute("osgi.content", (Object)SHA256.digest((File)file).asHex());
                    c.addAttribute("url", (Object)mavenURLResolver.resolver(file, (ArtifactResult)entry.getValue()));
                    c.addAttribute("size", (Object)file.length());
                    c.addAttribute("mime", (Object)"application/zip");
                    resourceBuilder.addCapability((CapReqBuilder)c);
                }
                resourcesRepository.add(resourceBuilder.build());
            }
            if (this.includeJar && this.project.getPackaging().equals("jar") && (current = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".jar")).exists()) {
                ResourceBuilder resourceBuilder = new ResourceBuilder();
                resourceBuilder.addFile(current, current.toURI());
                resourcesRepository.add(resourceBuilder.build());
            }
            xmlResourceGenerator.name(this.indexName).repository((Repository)resourcesRepository).save(this.outputFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.fail) {
            throw new MojoFailureException("One or more URI lookups failed");
        }
        this.attach(this.outputFile, "osgi-index", "xml");
        if (this.includeGzip) {
            File gzipOutputFile = new File(this.outputFile.getPath() + ".gz");
            try {
                xmlResourceGenerator.save(gzipOutputFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to create the gzipped output file");
            }
            this.attach(gzipOutputFile, "osgi-index", "xml.gz");
        }
    }

    private ArtifactRepository parseAltDistRepo(String repo, boolean releases, boolean snapshots) {
        if (repo == null) {
            return null;
        }
        String[] tokens = repo.split("::", 3);
        if (!"default".equals(tokens[1])) {
            logger.warn("Ignoring repository {} as it uses a non-default layout {}", (Object)tokens[0], (Object)tokens[1]);
            return null;
        }
        return new MavenArtifactRepository(tokens[0], tokens[2], (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(snapshots, "always", "warn"), new ArtifactRepositoryPolicy(releases, "always", "warn"));
    }

    protected void addDeploymentRepo(Map<String, ArtifactRepository> repositories, ArtifactRepository deploymentRepo) {
        if (deploymentRepo != null) {
            logger.debug("Located a deployment repository {}", (Object)deploymentRepo.getId());
            if (repositories.get(deploymentRepo.getId()) == null) {
                repositories.put(deploymentRepo.getId(), deploymentRepo);
            } else {
                logger.info("The configured deployment repository {} has the same id as one of the remote artifact repositories. It is assumed that these repositories are the same.", (Object)deploymentRepo.getId());
            }
        }
    }

    private void attach(File file, String type, String extension) {
        if (!this.attach) {
            logger.debug("The indexer is not attaching file {} with type {} and extension {} as attachment is disabled", new Object[]{file, type, extension});
            return;
        }
        DefaultArtifactHandler handler = new DefaultArtifactHandler(type);
        handler.setExtension(extension);
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, type, null, (ArtifactHandler)handler);
        artifact.setFile(file);
        this.project.addAttachedArtifact((Artifact)artifact);
    }

    class RepositoryURLResolver {
        private final Map<String, ArtifactRepository> repositories;

        public RepositoryURLResolver(Map<String, ArtifactRepository> repositories) {
            this.repositories = repositories;
        }

        public URI resolver(File file, ArtifactResult artifactResult) throws Exception {
            try {
                if (IndexerMojo.this.localURLs == LocalURLs.REQUIRED) {
                    return file.toURI();
                }
                org.eclipse.aether.artifact.Artifact artifact = artifactResult.getArtifact();
                ArtifactRepository repo = this.repositories.get(artifactResult.getRepository().getId());
                if (repo == null) {
                    if (IndexerMojo.this.localURLs == LocalURLs.ALLOWED) {
                        logger.info("The Artifact {} could not be found in any repository, returning the local location", (Object)artifact);
                        return file.toURI();
                    }
                    throw new FileNotFoundException("Unable to index artifact " + artifact + ". The repository " + artifactResult.getRepository().getId() + " is not known to this resolver");
                }
                String baseUrl = repo.getUrl();
                if (baseUrl.startsWith("file:")) {
                    baseUrl = new File(baseUrl.substring(5)).toURI().normalize().toString();
                }
                if (!baseUrl.endsWith("/")) {
                    baseUrl = baseUrl + "/";
                }
                String artifactPath = repo.getLayout().pathOf(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifact));
                while (artifactPath.startsWith("/")) {
                    artifactPath = artifactPath.substring(1);
                }
                return URI.create(baseUrl).resolve(artifactPath).normalize();
            }
            catch (Exception e) {
                IndexerMojo.this.fail = true;
                logger.error("Failed to determine the artifact URI for artifact {}", (Object)artifactResult.getArtifact(), (Object)e);
                throw e;
            }
        }
    }

    class MavenURLResolver {
        public static final String MIME = "application/zip";

        MavenURLResolver() {
        }

        public URI resolver(File file, ArtifactResult artifactResult) throws Exception {
            try {
                org.eclipse.aether.artifact.Artifact artifact = artifactResult.getArtifact();
                StringBuilder sb = new StringBuilder("mvn://");
                sb.append(artifact.getGroupId()).append("/").append(artifact.getArtifactId()).append("/");
                if (artifact.getVersion() != null) {
                    sb.append(artifact.getVersion());
                }
                sb.append("/");
                String type = artifact.getProperty("type", artifact.getExtension());
                if (type != null) {
                    sb.append(type);
                }
                sb.append("/");
                if (artifact.getClassifier() != null) {
                    sb.append(artifact.getClassifier());
                }
                return URI.create(sb.toString()).normalize();
            }
            catch (Exception e) {
                IndexerMojo.this.fail = true;
                logger.error("Failed to determine the artifact URI", (Throwable)e);
                throw e;
            }
        }
    }
}

