/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview.playbackspeed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class PlaybackSpeedOptions {
    private ArrayList<Float> speeds = new ArrayList<Float>(Collections.singletonList(Float.valueOf(1.0f)));

    public PlaybackSpeedOptions addSpeeds(ArrayList<Float> speeds) {
        this.speeds.addAll(speeds);
        Collections.sort(this.speeds);
        if (this.containsIllegalNumbers()) {
            throw new IllegalArgumentException("The speeds array must contain only numbers between 0 and 4!");
        }
        return this;
    }

    private boolean containsIllegalNumbers() {
        int size = this.speeds.size();
        for (int i = 0; i < size; ++i) {
            if (!(this.speeds.get(i).floatValue() < 0.0f) && !(this.speeds.get(i).floatValue() > 4.0f)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Float> getSpeeds() {
        return new ArrayList<Float>(new HashSet<Float>(this.speeds));
    }
}

