/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.EntityValueAdapter;
import com.sleepycat.persist.KeysIndex;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SubIndex;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryIndex<SK, PK, E>
extends BasicIndex<SK, E> {
    private SecondaryDatabase secDb;
    private Database keysDb;
    private PrimaryIndex priIndex;
    private EntityBinding entityBinding;
    private EntityIndex<SK, PK> keysIndex;
    private SortedMap<SK, E> map;

    public SecondaryIndex(SecondaryDatabase database, Database keysDatabase, PrimaryIndex<PK, E> primaryIndex, Class<SK> secondaryKeyClass, EntryBinding secondaryKeyBinding) throws DatabaseException {
        super(database, secondaryKeyClass, secondaryKeyBinding, new EntityValueAdapter<E>(primaryIndex.getEntityClass(), primaryIndex.getEntityBinding(), true));
        this.secDb = database;
        this.keysDb = keysDatabase;
        this.priIndex = primaryIndex;
        this.entityBinding = primaryIndex.getEntityBinding();
    }

    public SecondaryDatabase getDatabase() {
        return this.secDb;
    }

    public Database getKeysDatabase() {
        return this.keysDb;
    }

    public PrimaryIndex<PK, E> getPrimaryIndex() {
        return this.priIndex;
    }

    public Class<SK> getKeyClass() {
        return this.keyClass;
    }

    public EntryBinding getKeyBinding() {
        return this.keyBinding;
    }

    public synchronized EntityIndex<SK, PK> keysIndex() throws DatabaseException {
        if (this.keysIndex == null) {
            if (this.keysDb == null) {
                DatabaseConfig config = this.secDb.getConfig();
                config.setReadOnly(true);
                this.keysDb = this.db.getEnvironment().openDatabase(null, this.secDb.getDatabaseName(), config);
            }
            this.keysIndex = new KeysIndex(this.keysDb, this.keyClass, this.keyBinding, this.priIndex.getKeyClass(), this.priIndex.getKeyBinding());
        }
        return this.keysIndex;
    }

    public EntityIndex<PK, E> subIndex(SK key) throws DatabaseException {
        return new SubIndex(this, this.entityBinding, key);
    }

    @Override
    public E get(SK key) throws DatabaseException {
        return this.get((Transaction)null, key, (LockMode)null);
    }

    @Override
    public E get(Transaction txn, SK key, LockMode lockMode) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry pkeyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationStatus status = this.secDb.get(txn, keyEntry, pkeyEntry, dataEntry, lockMode);
        if (status == OperationStatus.SUCCESS) {
            return (E)this.entityBinding.entryToObject(pkeyEntry, dataEntry);
        }
        return null;
    }

    @Override
    public Map<SK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<SK, E> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap(this.db, this.keyBinding, this.entityBinding, true);
        }
        return this.map;
    }
}

