/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.store;

import be.ugent.rml.store.Quad;
import be.ugent.rml.term.Term;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.rio.RDFFormat;

public abstract class QuadStore {
    public abstract boolean equals(Object var1);

    public abstract void removeQuads(Term var1, Term var2, Term var3, Term var4);

    public abstract boolean contains(Term var1, Term var2, Term var3, Term var4);

    public abstract boolean isIsomorphic(QuadStore var1);

    public abstract boolean isSubset(QuadStore var1);

    public abstract void removeDuplicates();

    public abstract void addQuad(Term var1, Term var2, Term var3, Term var4);

    public abstract List<Quad> getQuads(Term var1, Term var2, Term var3, Term var4);

    public abstract void copyNameSpaces(QuadStore var1);

    public abstract void addNameSpace(String var1, String var2);

    public abstract void removeNameSpace(String var1);

    public abstract boolean isEmpty();

    public abstract int size();

    public abstract void read(InputStream var1, String var2, RDFFormat var3) throws Exception;

    public abstract void write(Writer var1, String var2) throws Exception;

    public final void write(ByteArrayOutputStream out, String format) throws Exception {
        this.write(new BufferedWriter(new OutputStreamWriter(out)), format);
    }

    public final void write(PrintStream out, String format) throws Exception {
        this.write(new PrintWriter(out), format);
    }

    public final Quad getQuad(Term subject, Term predicate, Term object, Term graph) throws Exception {
        List<Quad> list = this.getQuads(subject, predicate, object, graph);
        if (list.size() != 1) {
            throw new Exception(String.format("Single Quad expected, found %s", list.size()));
        }
        return list.get(0);
    }

    public final Quad getQuad(Term subject, Term predicate, Term object) throws Exception {
        return this.getQuad(subject, predicate, object, null);
    }

    public final List<Quad> getQuads(Term subject, Term predicate, Term object) {
        return this.getQuads(subject, predicate, object, null);
    }

    public abstract List<Term> getSubjects();

    public final boolean contains(Term subject, Term predicate, Term object) {
        return this.contains(subject, predicate, object, null);
    }

    public final void addQuad(Term subject, Term predicate, Term object) {
        this.addQuad(subject, predicate, object, null);
    }

    public final void addQuad(Quad q) {
        this.addQuad(q.getSubject(), q.getPredicate(), q.getObject(), q.getGraph());
    }

    public final void addQuads(List<Quad> quads) {
        quads.forEach(quad -> this.addQuad(quad.getSubject(), quad.getPredicate(), quad.getObject(), quad.getGraph()));
    }

    public final void removeQuads(Term subject, Term predicate, Term object) {
        this.removeQuads(subject, predicate, object, null);
    }

    public final void removeQuads(Quad quad) {
        this.removeQuads(quad.getSubject(), quad.getPredicate(), quad.getObject(), quad.getGraph());
    }

    public final void removeQuads(List<Quad> quads) {
        for (Quad quad : quads) {
            this.removeQuads(quad);
        }
    }

    public final void tryPropertyTranslation(Term from, Term fromPredicate, Term to, Term toPredicate) {
        List<Quad> quads = this.getQuads(from, fromPredicate, null);
        for (Quad quad : quads) {
            this.addQuad(to, toPredicate, quad.getObject());
        }
        this.removeQuads(quads);
    }

    public final void renameAllPredicates(Term fromPredicate, Term toPredicate) {
        List<Quad> quads = this.getQuads(null, fromPredicate, null);
        for (Quad q : quads) {
            this.addQuad(q.getSubject(), toPredicate, q.getObject());
        }
        this.removeQuads(quads);
    }

    public final void renameAllObjects(Term fromObject, Term toObject) {
        List<Quad> quads = this.getQuads(null, null, fromObject);
        for (Quad q : quads) {
            this.addQuad(q.getSubject(), q.getPredicate(), toObject);
        }
        this.removeQuads(quads);
    }

    public final String toString() {
        StringBuilder output = new StringBuilder();
        List<Quad> quads = this.getQuads(null, null, null);
        for (Quad q : quads) {
            output.append(q.getSubject()).append(" ").append(q.getPredicate()).append(" ").append(q.getObject()).append(" ").append(q.getGraph()).append("\n");
        }
        return output.toString();
    }

    public final String toSortedString() {
        StringBuilder output = new StringBuilder();
        List<Quad> quads = this.getQuads(null, null, null);
        Collections.sort(quads);
        for (Quad q : quads) {
            output.append(q.getSubject()).append(" ").append(q.getPredicate()).append(" ").append(q.getObject()).append(" ").append(q.getGraph()).append("\n");
        }
        return output.toString();
    }
}

