/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.iterators.CSVSourceIterator;
import be.ugent.idlab.knows.dataio.iterators.ExcelSourceIterator;
import be.ugent.idlab.knows.dataio.iterators.ODSSourceIterator;
import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.rml.records.CSVW;
import be.ugent.rml.records.ReferenceFormulationRecordFactory;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.Term;
import java.util.ArrayList;
import java.util.List;

public class TabularSourceFactory
implements ReferenceFormulationRecordFactory {
    @Override
    public List<Record> getRecords(Access access, Term logicalSource, QuadStore rmlStore) throws Exception {
        return switch (access.getContentType().toLowerCase()) {
            case "text/csv" -> this.getRecordsForCSV(access);
            case "text/csvw" -> this.getRecordsForCSVW(access, rmlStore, logicalSource);
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" -> this.getRecordsForExcel(access);
            case "application/vnd.oasis.opendocument.spreadsheet" -> this.getRecordsForODT(access);
            default -> throw new IllegalArgumentException(String.format("Unrecognised content type: %s", access.getContentType()));
        };
    }

    private List<Record> getRecordsForExcel(Access access) throws Exception {
        ArrayList<Record> output = new ArrayList<Record>();
        try (ExcelSourceIterator iterator = new ExcelSourceIterator(access);){
            iterator.forEachRemaining(output::add);
        }
        return output;
    }

    private List<Record> getRecordsForODT(Access access) throws Exception {
        ArrayList<Record> output = new ArrayList<Record>();
        try (ODSSourceIterator iterator = new ODSSourceIterator(access);){
            iterator.forEachRemaining(output::add);
        }
        return output;
    }

    private List<Record> getRecordsForCSV(Access access) throws Exception {
        try (CSVSourceIterator iterator = new CSVSourceIterator(access);){
            ArrayList<Record> results = new ArrayList<Record>();
            iterator.forEachRemaining(results::add);
            ArrayList<Record> arrayList = results;
            return arrayList;
        }
    }

    private List<Record> getRecordsForCSVW(Access access, QuadStore rmlStore, Term logicalSource) throws Exception {
        CSVW csvw = new CSVW(rmlStore, logicalSource);
        return csvw.getRecords(access);
    }
}

