/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.rml.Utils;
import be.ugent.rml.access.AccessFactory;
import be.ugent.rml.records.HTMLRecordFactory;
import be.ugent.rml.records.JSONRecordFactory;
import be.ugent.rml.records.ReferenceFormulation;
import be.ugent.rml.records.ReferenceFormulationRecordFactory;
import be.ugent.rml.records.TabularSourceFactory;
import be.ugent.rml.records.XMLRecordFactory;
import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordsFactory {
    private Map<Access, Map<String, Map<String, List<Record>>>> recordsCache;
    private AccessFactory accessFactory;
    private Map<String, ReferenceFormulationRecordFactory> referenceFormulationRecordFactoryMap;
    private static final Logger logger = LoggerFactory.getLogger(RecordsFactory.class);

    public RecordsFactory(String basePath, String mappingPath) {
        this.accessFactory = new AccessFactory(basePath, mappingPath);
        this.recordsCache = new HashMap<Access, Map<String, Map<String, List<Record>>>>();
        this.referenceFormulationRecordFactoryMap = new HashMap<String, ReferenceFormulationRecordFactory>();
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.XPath, new XMLRecordFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.SPARQLResultsXML, new XMLRecordFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.JSONPath, new JSONRecordFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.SPARQLResultsJSON, new JSONRecordFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.CSV, new TabularSourceFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.RDBTable, new TabularSourceFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.RDBQuery, new TabularSourceFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.SPARQLResultsCSV, new TabularSourceFactory());
        this.referenceFormulationRecordFactoryMap.put(ReferenceFormulation.CSS3, new HTMLRecordFactory());
    }

    public List<Record> createRecords(Term triplesMap, QuadStore rmlStore) throws Exception {
        List<Term> logicalSources = Utils.getObjectsFromQuads(rmlStore.getQuads(triplesMap, new NamedNode("http://w3id.org/rml/logicalSource"), null));
        if (!logicalSources.isEmpty()) {
            Term logicalSource = logicalSources.get(0);
            Access access = this.accessFactory.getAccess(logicalSource, rmlStore);
            List<Term> referenceFormulations = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/referenceFormulation"), null));
            if (referenceFormulations.isEmpty()) {
                referenceFormulations = List.of(new NamedNode(ReferenceFormulation.RDBTable));
            }
            String referenceFormulation = referenceFormulations.get(0).getValue();
            return this.getRecords(access, logicalSource, referenceFormulation, rmlStore);
        }
        throw new Error("No Logical Source is found for " + String.valueOf(triplesMap) + ". Exactly one Logical Source is required per Triples Map.");
    }

    private List<Record> getRecordsFromCache(Access access, String referenceFormulation, String hash) {
        if (this.recordsCache.containsKey(access) && this.recordsCache.get(access).containsKey(referenceFormulation) && this.recordsCache.get(access).get(referenceFormulation).containsKey(hash)) {
            return this.recordsCache.get(access).get(referenceFormulation).get(hash);
        }
        return null;
    }

    private void putRecordsIntoCache(Access access, String referenceFormulation, String hash, List<Record> records) {
        if (!this.recordsCache.containsKey(access)) {
            this.recordsCache.put(access, new HashMap());
        }
        if (!this.recordsCache.get(access).containsKey(referenceFormulation)) {
            this.recordsCache.get(access).put(referenceFormulation, new HashMap());
        }
        this.recordsCache.get(access).get(referenceFormulation).put(hash, records);
    }

    private List<Record> getRecords(Access access, Term logicalSource, String referenceFormulation, QuadStore rmlStore) throws Exception {
        String logicalSourceHash = this.hashLogicalSource(logicalSource, rmlStore);
        List<Record> records = this.getRecordsFromCache(access, referenceFormulation, logicalSourceHash);
        if (records == null) {
            if (!this.referenceFormulationRecordFactoryMap.containsKey(referenceFormulation)) {
                logger.error("Referenceformulation {} is unsupported!", (Object)referenceFormulation);
                return List.of();
            }
            ReferenceFormulationRecordFactory factory = this.referenceFormulationRecordFactoryMap.get(referenceFormulation);
            records = factory.getRecords(access, logicalSource, rmlStore);
            this.putRecordsIntoCache(access, referenceFormulation, logicalSourceHash, records);
            return records;
        }
        return records;
    }

    private String hashLogicalSource(Term logicalSource, QuadStore rmlStore) {
        List<Quad> quads = rmlStore.getQuads(logicalSource, null, null);
        String[] hash = new String[]{""};
        quads.forEach(quad -> {
            if (!quad.getPredicate().getValue().equals("http://w3id.org/rml/source") && !quad.getPredicate().getValue().equals("http://w3id.org/rml/referenceFormulation")) {
                hash[0] = hash[0] + quad.getObject().getValue();
            }
        });
        return hash[0];
    }
}

