/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.records;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.access.VirtualAccess;
import be.ugent.idlab.knows.dataio.iterators.SourceIterator;
import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.rml.Utils;
import be.ugent.rml.records.ReferenceFormulationRecordFactory;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IteratorFormat
implements ReferenceFormulationRecordFactory {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<Access, VirtualAccess> cache = new HashMap<Access, VirtualAccess>();

    @Override
    public List<Record> getRecords(Access access, Term logicalSource, QuadStore rmlStore) throws Exception {
        if (!this.cache.containsKey(access)) {
            this.logger.debug("No document found for {}. Creating new one", (Object)access);
            VirtualAccess virtualAccess = new VirtualAccess(access);
            this.cache.put(access, virtualAccess);
        }
        List<Term> iterators = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/iterator"), null));
        Term referenceFormulation = rmlStore.getQuad(logicalSource, new NamedNode("http://w3id.org/rml/referenceFormulation"), null).getObject();
        String iterator = referenceFormulation.equals(new NamedNode("http://www.w3.org/ns/formats/SPARQL_Results_JSON")) ? "$.results.bindings[*]" : (referenceFormulation.equals(new NamedNode("http://www.w3.org/ns/formats/SPARQL_Results_XML")) ? "//result/binding" : (referenceFormulation.equals(new NamedNode("http://www.w3.org/ns/formats/SPARQL_Results_CSV")) ? "" : (iterators.isEmpty() ? "/Results/row" : iterators.get(0).getValue())));
        ArrayList<Record> sources = new ArrayList<Record>();
        try (SourceIterator it = this.getIterator((Access)this.cache.get(access), iterator);){
            it.forEachRemaining(sources::add);
        }
        return sources;
    }

    protected abstract SourceIterator getIterator(Access var1, String var2) throws Exception;
}

