/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.metadata;

import be.ugent.rml.Utils;
import be.ugent.rml.metadata.DatasetLevelMetadataGenerator;
import be.ugent.rml.metadata.Metadata;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.store.RDF4JStore;
import be.ugent.rml.term.BlankNode;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.ProvenancedQuad;
import be.ugent.rml.term.Term;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class MetadataGenerator {
    private QuadStore mdStore;
    private DETAIL_LEVEL detailLevel;
    private QuadStore inputData;
    private String[] mappingFiles;
    private List<Term> triplesMaps;
    private List<BiConsumer<Term, ProvenancedQuad>> generationFunctions;
    private List<Term> logicalSources;
    private Set<String> distinctSubjects;
    private Set<String> distinctObjects;
    private Set<String> distinctClasses;
    private Set<String> distinctProperties;
    private Map<Term, Term> triplesMaptoActivityMap;
    private Map<Term, Term> termMaptoActivityMap;
    private Term rdfDataset;
    private Term rdfDatasetGeneration;
    private Term rmlMapper;

    public MetadataGenerator(DETAIL_LEVEL detailLevel, String outputFile, String[] mappingFiles, QuadStore inputData, QuadStore metadataStore) {
        this.mdStore = metadataStore;
        this.detailLevel = detailLevel;
        this.inputData = inputData;
        this.mappingFiles = mappingFiles;
        this.distinctSubjects = new HashSet<String>();
        this.distinctObjects = new HashSet<String>();
        this.distinctClasses = new HashSet<String>();
        this.distinctProperties = new HashSet<String>();
        this.generationFunctions = new ArrayList<BiConsumer<Term, ProvenancedQuad>>();
        this.rdfDataset = new NamedNode(String.format("file://%s", outputFile));
        this.rdfDatasetGeneration = new BlankNode(Utils.hashCode(outputFile));
        this.rmlMapper = new NamedNode("http://rml.io/tool/rmlmapper-java");
        if (detailLevel.getLevel() >= DETAIL_LEVEL.TRIPLE.getLevel()) {
            this.addTripleLevelFunctions();
        }
        if (detailLevel.getLevel() >= DETAIL_LEVEL.TERM.getLevel()) {
            this.addTermLevelFunctions();
        }
    }

    public MetadataGenerator(DETAIL_LEVEL detailLevel, String outputFile, String[] mappingFiles, QuadStore inputData) {
        this(detailLevel, outputFile, mappingFiles, inputData, new RDF4JStore());
    }

    public void insertQuad(ProvenancedQuad provenancedQuad) {
        if (provenancedQuad.getSubject() != null & provenancedQuad.getPredicate() != null & provenancedQuad.getObject() != null) {
            BlankNode node = new BlankNode(Utils.hashCode(provenancedQuad.getSubject().getTerm().getValue() + provenancedQuad.getPredicate().getTerm().getValue() + provenancedQuad.getObject().getTerm().getValue()));
            this.mdStore.addQuad(node, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement"));
            this.mdStore.addQuad(node, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject"), provenancedQuad.getSubject().getTerm());
            this.mdStore.addQuad(node, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate"), provenancedQuad.getPredicate().getTerm());
            this.mdStore.addQuad(node, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#object"), provenancedQuad.getObject().getTerm());
            for (BiConsumer<Term, ProvenancedQuad> function : this.generationFunctions) {
                function.accept(node, provenancedQuad);
            }
        }
    }

    public void preMappingGeneration(List<Term> triplesMaps, QuadStore mappingQuads) {
        this.triplesMaps = triplesMaps;
        if (this.detailLevel.getLevel() >= DETAIL_LEVEL.TRIPLE.getLevel()) {
            this.generatePreTripleLevelDetailMetadata();
            if (this.detailLevel.getLevel() >= DETAIL_LEVEL.TERM.getLevel()) {
                this.generatePreTermLevelDetailMetadata(mappingQuads);
            }
        }
    }

    public void postMappingGeneration(String startTimestamp, String stopTimestamp, QuadStore result) {
        if (this.detailLevel.getLevel() >= DETAIL_LEVEL.DATASET.getLevel()) {
            DatasetLevelMetadataGenerator.createMetadata(this.rdfDataset, this.rdfDatasetGeneration, this.rmlMapper, this.mdStore, this.getLogicalSources(this.triplesMaps, this.inputData), startTimestamp, stopTimestamp, this.mappingFiles);
            if (this.detailLevel.getLevel() >= DETAIL_LEVEL.TRIPLE.getLevel()) {
                this.generatePostTripleLevelDetailMetadata(result);
            }
        }
    }

    private void generatePreTripleLevelDetailMetadata() {
        this.triplesMaptoActivityMap = new HashMap<Term, Term>();
        for (Term triplesMap : this.triplesMaps) {
            this.mdStore.addQuad(triplesMap, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.w3.org/ns/prov#Entity"));
            this.mdStore.addQuad(triplesMap, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://rdfs.org/ns/void#Dataset"));
            this.mdStore.addQuad(triplesMap, new NamedNode("http://rdfs.org/ns/void#dataDump"), this.rdfDataset);
            this.createActivityStatements(triplesMap, this.triplesMaptoActivityMap);
        }
    }

    private void generatePreTermLevelDetailMetadata(QuadStore mappingQuads) {
        this.termMaptoActivityMap = new HashMap<Term, Term>();
        for (Term triplesMap : this.triplesMaps) {
            List<Term> subjectMaps = Utils.getObjectsFromQuads(mappingQuads.getQuads(triplesMap, new NamedNode("http://w3id.org/rml/subjectMap"), null));
            if (!subjectMaps.isEmpty()) {
                Term subjectMap = subjectMaps.get(0);
                this.createActivityStatementsWithResultActivity(subjectMap, this.termMaptoActivityMap, this.triplesMaptoActivityMap.get(triplesMap));
            }
            List<Term> predicateObjectMaps = Utils.getObjectsFromQuads(mappingQuads.getQuads(triplesMap, new NamedNode("http://w3id.org/rml/predicateObjectMap"), null));
            for (Term pom : predicateObjectMaps) {
                Term pomActivity = this.createActivityStatementsWithResultActivity(pom, this.termMaptoActivityMap, this.triplesMaptoActivityMap.get(triplesMap));
                List<Term> predicateMaps = Utils.getObjectsFromQuads(mappingQuads.getQuads(pom, new NamedNode("http://w3id.org/rml/predicateMap"), null));
                List<Term> objectMaps = Utils.getObjectsFromQuads(mappingQuads.getQuads(pom, new NamedNode("http://w3id.org/rml/objectMap"), null));
                this.createActivityStatementsWithResultActivity(predicateMaps, this.termMaptoActivityMap, pomActivity);
                this.createActivityStatementsWithResultActivity(objectMaps, this.termMaptoActivityMap, pomActivity);
            }
        }
    }

    private Term createActivityStatements(Term termMap, Map<Term, Term> map) {
        Term termMapActivity = termMap instanceof BlankNode ? new BlankNode(termMap.getValue() + "Activity") : new NamedNode(termMap.getValue() + "Activity");
        if (map != null) {
            map.put(termMap, termMapActivity);
        }
        this.mdStore.addQuad(termMapActivity, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.w3.org/ns/prov#Activity"));
        this.mdStore.addQuad(termMapActivity, new NamedNode("http://www.w3.org/ns/prov#used"), termMap);
        return termMapActivity;
    }

    private Term createActivityStatementsWithResultActivity(Term termMap, Map<Term, Term> map, Term resultActivity) {
        Term termMapActivity = this.createActivityStatements(termMap, map);
        this.mdStore.addQuad(resultActivity, new NamedNode("http://www.w3.org/ns/prov#wasInformedBy"), termMapActivity);
        return termMapActivity;
    }

    private Term createActivityStatementsWithResultActivity(List<Term> termMaps, Map<Term, Term> map, Term resultActivity) {
        if (!termMaps.isEmpty()) {
            return this.createActivityStatementsWithResultActivity(termMaps.get(0), map, resultActivity);
        }
        return null;
    }

    private void generatePostTripleLevelDetailMetadata(QuadStore result) {
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.w3.org/ns/prov#Entity"));
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://rdfs.org/ns/void#Dataset"));
        this.getLogicalSources(this.triplesMaps, this.inputData).forEach(inputSource -> this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://www.w3.org/ns/prov#wasDerivedFrom"), (Term)inputSource));
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://www.w3.org/ns/prov#wasGeneratedBy"), this.rdfDatasetGeneration);
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://rdfs.org/ns/void#triples"), new Literal(Integer.toString(result.getQuads(null, null, null, null).size()), new NamedNode("http://www.w3.org/2001/XMLSchema#integer")));
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://rdfs.org/ns/void#distinctSubjects"), new Literal(Integer.toString(this.distinctSubjects.size()), new NamedNode("http://www.w3.org/2001/XMLSchema#integer")));
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://rdfs.org/ns/void#distinctObjects"), new Literal(Integer.toString(this.distinctObjects.size()), new NamedNode("http://www.w3.org/2001/XMLSchema#integer")));
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://rdfs.org/ns/void#classes"), new Literal(Integer.toString(this.distinctClasses.size()), new NamedNode("http://www.w3.org/2001/XMLSchema#integer")));
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://rdfs.org/ns/void#properties"), new Literal(Integer.toString(this.distinctProperties.size()), new NamedNode("http://www.w3.org/2001/XMLSchema#integer")));
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://rdfs.org/ns/void#documents"), new Literal("1", new NamedNode("http://www.w3.org/2001/XMLSchema#integer")));
        this.mdStore.addQuad(this.rdfDataset, new NamedNode("http://rdfs.org/ns/void#feature"), new NamedNode("http://www.w3.org/ns/formats/N-Quads"));
    }

    private List<Term> getLogicalSources(List<Term> triplesMaps, QuadStore rmlStore) {
        if (this.logicalSources == null) {
            this.logicalSources = new ArrayList<Term>();
            for (Term triplesMap : triplesMaps) {
                List<Term> logicalSourcesObjects = Utils.getObjectsFromQuads(rmlStore.getQuads(triplesMap, new NamedNode("http://w3id.org/rml/logicalSource"), null));
                if (logicalSourcesObjects.isEmpty()) {
                    throw new Error("No Logical Source is found for " + String.valueOf(triplesMap) + ". Exactly one Logical Source is required per Triples Map.");
                }
                Term logicalSource = logicalSourcesObjects.get(0);
                if (logicalSource instanceof BlankNode) {
                    List<Term> sourceObjects = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/source"), null));
                    if (sourceObjects.isEmpty()) {
                        throw new Error("No Source is found for " + String.valueOf(triplesMap) + ". Exactly one Source is required per Logical Source.");
                    }
                    Term source = sourceObjects.get(0);
                    Term sourceNode = source instanceof Literal ? new NamedNode(String.format("file://%s", sourceObjects.get(0).getValue())) : source;
                    this.logicalSources.add(sourceNode);
                    continue;
                }
                this.logicalSources.add(logicalSource);
            }
        }
        return this.logicalSources;
    }

    private void addTripleLevelFunctions() {
        this.generationFunctions.add((node, pquad) -> {
            Term subjectTM = pquad.getSubject().getMetadata().getTriplesMap();
            this.mdStore.addQuad((Term)node, new NamedNode("http://www.w3.org/ns/prov#wasDerivedFrom"), subjectTM);
            if (pquad.getObject().getMetadata() != null && pquad.getObject().getMetadata().getTriplesMap() != null) {
                Term objectTM = pquad.getObject().getMetadata().getTriplesMap();
                this.mdStore.addQuad((Term)node, new NamedNode("http://www.w3.org/ns/prov#wasDerivedFrom"), objectTM);
            }
        });
        this.generationFunctions.add((node, pquad) -> this.mdStore.addQuad((Term)node, new NamedNode("http://www.w3.org/ns/prov#generatedAtTime"), new Literal(Instant.now().toString(), new NamedNode("http://www.w3.org/2001/XMLSchema#dateTime"))));
        this.generationFunctions.add((node, pquad) -> {
            this.distinctSubjects.add(pquad.getSubject().getTerm().getValue());
            this.distinctObjects.add(pquad.getObject().getTerm().getValue());
            this.distinctProperties.add(pquad.getPredicate().getTerm().getValue());
            if (pquad.getPredicate().getTerm().getValue().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                this.distinctClasses.add(pquad.getObject().getTerm().getValue());
            }
        });
    }

    private void addTermLevelFunctions() {
        this.generationFunctions.add((node, pquad) -> {
            Term objectNode;
            Metadata subjectMD = pquad.getSubject().getMetadata();
            Metadata predicateMD = pquad.getPredicate().getMetadata();
            Metadata objectMD = pquad.getObject().getMetadata();
            this.mdStore.addQuad(pquad.getSubject().getTerm(), new NamedNode("http://www.w3.org/ns/prov#wasDerivedFrom"), subjectMD.getTriplesMap());
            if (!(subjectMD.getSourceMap() instanceof BlankNode)) {
                this.mdStore.addQuad(pquad.getSubject().getTerm(), new NamedNode("http://www.w3.org/ns/prov#wasGeneratedBy"), this.termMaptoActivityMap.get(subjectMD.getSourceMap()));
            }
            if (!(predicateMD.getSourceMap() instanceof BlankNode)) {
                this.createValueAndGeneratedByStatements(pquad.getPredicate().getTerm(), this.termMaptoActivityMap.get(predicateMD.getSourceMap()));
            }
            Term term = objectNode = pquad.getObject().getTerm() instanceof Literal ? this.createValueStatements(pquad.getObject().getTerm()) : pquad.getObject().getTerm();
            if (objectMD.getTriplesMap() != null) {
                this.mdStore.addQuad(objectNode, new NamedNode("http://www.w3.org/ns/prov#wasDerivedFrom"), objectMD.getTriplesMap());
            } else {
                this.mdStore.addQuad(objectNode, new NamedNode("http://www.w3.org/ns/prov#wasDerivedFrom"), subjectMD.getTriplesMap());
            }
            if (!(objectMD.getSourceMap() instanceof BlankNode)) {
                this.createValueAndGeneratedByStatements(pquad.getObject().getTerm(), this.termMaptoActivityMap.get(objectMD.getSourceMap()));
            }
        });
    }

    private Term createValueStatements(Term value) {
        BlankNode node = new BlankNode();
        this.mdStore.addQuad(node, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("http://www.w3.org/ns/prov#Entity"));
        this.mdStore.addQuad(node, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#value"), value);
        return node;
    }

    private Term createValueAndGeneratedByStatements(Term value, Term generatedBy) {
        Term node = this.createValueStatements(value);
        this.mdStore.addQuad(node, new NamedNode("http://www.w3.org/ns/prov#wasGeneratedBy"), generatedBy);
        return node;
    }

    public DETAIL_LEVEL getDetailLevel() {
        return this.detailLevel;
    }

    public QuadStore getResult() {
        return this.mdStore;
    }

    public static enum DETAIL_LEVEL {
        DATASET(0),
        TRIPLE(1),
        TERM(2);

        private int level;

        private DETAIL_LEVEL(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

