/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml;

import be.ugent.rml.MyFileUtils;
import be.ugent.rml.extractor.ConstantExtractor;
import be.ugent.rml.extractor.Extractor;
import be.ugent.rml.extractor.ReferenceExtractor;
import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final Pattern regexPatternLanguageTag = Pattern.compile("^((?:(en-GB-oed|i-ami|i-bnn|i-default|i-enochian|i-hak|i-klingon|i-lux|i-mingo|i-navajo|i-pwn|i-tao|i-tay|i-tsu|sgn-BE-FR|sgn-BE-NL|sgn-CH-DE)|(art-lojban|cel-gaulish|no-bok|no-nyn|zh-guoyu|zh-hakka|zh-min|zh-min-nan|zh-xiang))|((?:([A-Za-z]{2,3}(-(?:[A-Za-z]{3}(-[A-Za-z]{3}){0,2}))?)|[A-Za-z]{4})(-(?:[A-Za-z]{4}))?(-(?:[A-Za-z]{2}|[0-9]{3}))?(-(?:[A-Za-z0-9]{5,8}|[0-9][A-Za-z0-9]{3}))*(-(?:[0-9A-WY-Za-wy-z](-[A-Za-z0-9]{2,8})+))*(-(?:x(-[A-Za-z0-9]{1,8})+))?)|(?:x(-[A-Za-z0-9]{1,8})+))$");

    public static Reader getReaderFromLocation(String location) throws IOException {
        return Utils.getReaderFromLocation(location, null, "");
    }

    public static Reader getReaderFromLocation(String location, File basePath, String contentType) throws IOException {
        if (Utils.isRemoteFile(location)) {
            try {
                return Utils.getReaderFromURL(new URL(location), contentType);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return Utils.getReaderFromFile(Utils.getFile(location, basePath));
    }

    public static InputStream getInputStreamFromLocation(String location, File basePath, String contentType) throws IOException {
        return Utils.getInputStreamFromLocation(location, basePath, contentType, new HashMap<String, String>());
    }

    public static InputStream getInputStreamFromLocation(String location, File basePath, String contentType, Map<String, String> headers) throws IOException {
        if (Utils.isRemoteFile(location)) {
            return Utils.getInputStreamFromURL(new URL(location), contentType, headers);
        }
        return Utils.getInputStreamFromFile(Utils.getFile(location, basePath));
    }

    public static InputStream getInputStreamFromFileOrContentString(String mOptionValue) {
        InputStream out;
        String extension;
        logger.debug("{} mapping file", (Object)mOptionValue);
        try {
            extension = FilenameUtils.getExtension((String)mOptionValue);
        }
        catch (IllegalArgumentException e) {
            return IOUtils.toInputStream((String)mOptionValue, (Charset)StandardCharsets.UTF_8);
        }
        if (extension != null) {
            mOptionValue = mOptionValue.replaceAll("\\\\", "/");
        }
        try {
            switch (extension) {
                case "n3": {
                    out = Utils.getTurtleInputStreamForFormat(mOptionValue, RDFFormat.N3);
                    break;
                }
                case "nt": {
                    out = Utils.getTurtleInputStreamForFormat(mOptionValue, RDFFormat.NTRIPLES);
                    break;
                }
                case "nq": {
                    out = Utils.getTurtleInputStreamForFormat(mOptionValue, RDFFormat.NQUADS);
                    break;
                }
                case "rdf": 
                case "xml": {
                    out = Utils.getTurtleInputStreamForFormat(mOptionValue, RDFFormat.RDFXML);
                    break;
                }
                case "json": 
                case "jsonld": {
                    out = Utils.getTurtleInputStreamForFormat(mOptionValue, RDFFormat.JSONLD);
                    break;
                }
                case "ttl": {
                    out = Utils.getInputStreamFromLocation(mOptionValue, null, RDFFormat.TURTLE.getDefaultMIMEType());
                    break;
                }
                default: {
                    logger.info("Could not determine extension of file path. Trying Turtle format.");
                    out = Utils.getInputStreamFromLocation(mOptionValue, null, "text/turtle");
                    break;
                }
            }
        }
        catch (IOException e) {
            logger.info("Trying to read mapping as raw input string.");
            out = IOUtils.toInputStream((String)mOptionValue, (Charset)StandardCharsets.UTF_8);
        }
        return out;
    }

    private static InputStream getTurtleInputStreamForFormat(String mOptionValue, RDFFormat format) throws IOException {
        try (InputStream out = Utils.getInputStreamFromLocation(mOptionValue, null, format.getDefaultMIMEType());){
            Model model = Rio.parse((InputStream)out, (String)"", (RDFFormat)format, (Resource[])new Resource[0]);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Rio.write((Iterable)model, (OutputStream)output, (RDFFormat)RDFFormat.TURTLE);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static File getFile(String path) throws IOException {
        return Utils.getFile(path, null);
    }

    public static File getFile(String path, File basePath) throws IOException {
        File f = new File(path);
        if (f.isAbsolute()) {
            if (f.exists()) {
                return f;
            }
            throw new FileNotFoundException();
        }
        if (basePath == null) {
            try {
                basePath = new File(System.getProperty("user.dir"));
            }
            catch (Exception e) {
                throw new FileNotFoundException();
            }
        }
        logger.debug("Looking for file {} in basePath {}", (Object)path, (Object)basePath);
        f = new File(basePath, path);
        if (f.exists()) {
            return f;
        }
        logger.debug("File {} not found in {}", (Object)path, (Object)basePath);
        logger.debug("Looking for file {} in {} /../", (Object)path, (Object)basePath);
        f = new File(basePath, "../" + path);
        if (f.exists()) {
            return f;
        }
        logger.debug("File {} not found in {}", (Object)path, (Object)basePath);
        logger.debug("Looking for file {} in the resources directory", (Object)path);
        try {
            return MyFileUtils.getResourceAsFile(path);
        }
        catch (IOException iOException) {
            logger.debug("File {} not found in the resources directory", (Object)path);
            throw new FileNotFoundException(path);
        }
    }

    public static Reader getReaderFromURL(URL url) throws IOException {
        return new BufferedReader(new InputStreamReader(url.openStream()));
    }

    public static Reader getReaderFromURL(URL url, String contentType) throws IOException {
        return new BufferedReader(new InputStreamReader(Utils.getInputStreamFromURL(url, contentType)));
    }

    public static Reader getReaderFromFile(File file) throws FileNotFoundException {
        return new FileReader(file);
    }

    public static InputStream getInputStreamFromURL(URL url) throws IOException {
        return url.openStream();
    }

    public static InputStream getInputStreamFromURL(URL url, String contentType) {
        InputStream inputStream = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", contentType);
            connection.setRequestProperty("charset", "utf-8");
            connection.connect();
            inputStream = connection.getInputStream();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return inputStream;
    }

    public static InputStream getInputStreamFromURL(URL url, String contentType, Map<String, String> headers) {
        InputStream inputStream = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", contentType);
            if (!headers.containsKey("charset")) {
                headers.put("charset", "utf-8");
            }
            headers.forEach((name, value) -> {
                logger.debug("{}: {}", name, value);
                connection.setRequestProperty((String)name, (String)value);
            });
            logger.debug("trying to connect");
            connection.connect();
            logger.debug("getting inputstream");
            inputStream = connection.getInputStream();
            logger.debug("got inputstream");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return inputStream;
    }

    public static InputStream getInputStreamFromAuthURL(URL url, String contentType, Map<String, String> headers) throws Exception {
        InputStream inputStream = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", contentType);
            if (!headers.containsKey("charset")) {
                headers.put("charset", "utf-8");
            }
            headers.forEach((name, value) -> {
                logger.debug("{}: {}", name, value);
                connection.setRequestProperty((String)name, (String)value);
            });
            logger.debug("trying to connect");
            connection.connect();
            if (connection.getResponseCode() == 401) {
                throw new Exception("not authenticated");
            }
            logger.debug("getting inputstream");
            inputStream = connection.getInputStream();
            logger.debug("got inputstream");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return inputStream;
    }

    public static InputStream getInputStreamFromFile(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public static InputStream getPostRequestResponse(URL url, String contentType, byte[] auth) {
        InputStream inputStream = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("charset", "utf-8");
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", contentType);
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(auth);
            inputStream = connection.getInputStream();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return inputStream;
    }

    public static boolean isRemoteFile(String location) {
        return location.startsWith("https://") || location.startsWith("http://");
    }

    public static List<Term> getSubjectsFromQuads(List<Quad> quads) {
        ArrayList<Term> subjects = new ArrayList<Term>();
        for (Quad quad : quads) {
            subjects.add(quad.getSubject());
        }
        return subjects;
    }

    public static List<Term> getObjectsFromQuads(List<Quad> quads) {
        ArrayList<Term> objects = new ArrayList<Term>();
        for (Quad quad : quads) {
            objects.add(quad.getObject());
        }
        return objects;
    }

    public static List<String> getLiteralObjectsFromQuads(List<Quad> quads) {
        ArrayList<String> objects = new ArrayList<String>();
        for (Quad quad : quads) {
            objects.add(((Literal)quad.getObject()).getValue());
        }
        return objects;
    }

    public static List<Term> getList(QuadStore store, Term first) {
        ArrayList<Term> list = new ArrayList<Term>();
        return Utils.getList(store, first, list);
    }

    public static List<Term> getList(QuadStore store, Term first, List<Term> list) {
        if (first.equals(new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil"))) {
            return list;
        }
        Term value = Utils.getObjectsFromQuads(store.getQuads(first, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#first"), null)).get(0);
        Term next = Utils.getObjectsFromQuads(store.getQuads(first, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest"), null)).get(0);
        list.add(value);
        if (next.equals(new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil"))) {
            return list;
        }
        list = Utils.getList(store, next, list);
        return list;
    }

    public static boolean isValidrrLanguage(String s) {
        return regexPatternLanguageTag.matcher(s).matches();
    }

    public static String encodeURI(String url) {
        StringBuilder builder = new StringBuilder();
        String encoded = URLEncoder.encode(url, StandardCharsets.UTF_8);
        for (char c : encoded.toCharArray()) {
            if (c == '+') {
                builder.append("%20");
                continue;
            }
            if (c == '*') {
                builder.append("%2A");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String fileToString(File file) throws IOException {
        int intValueOfChar;
        Reader reader = Utils.getReaderFromFile(file);
        Object targetString = "";
        while ((intValueOfChar = reader.read()) != -1) {
            targetString = (String)targetString + (char)intValueOfChar;
        }
        reader.close();
        return targetString;
    }

    public static int selectedColumnHash(String query) {
        Pattern p = Pattern.compile("^SELECT(.*)FROM");
        Matcher m = p.matcher(query.replace("\n", " ").replace("\r", " ").trim());
        if (m.find()) {
            String columns = m.group(1);
            Object[] columnNames = columns.replace("DISTINCT", "").replace(" ", "").split(",");
            Arrays.sort(columnNames);
            return String.join((CharSequence)"", (CharSequence[])columnNames).hashCode();
        }
        throw new Error("Invalid query: " + query);
    }

    public static int getHash(String query) {
        return query.hashCode();
    }

    public static String readFile(String path, Charset encoding) throws IOException {
        if (encoding == null) {
            encoding = StandardCharsets.UTF_8;
        }
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static String getURLParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            result.append("&");
        }
        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }

    public static int getFreePortNumber() throws IOException {
        ServerSocket temp = new ServerSocket(0);
        temp.setReuseAddress(true);
        int portNumber = temp.getLocalPort();
        temp.close();
        return portNumber;
    }

    public static List<Extractor> parseTemplate(String template, boolean ignoreDoubleQuotes, boolean strictReferenceResolution) {
        ArrayList<Extractor> extractors = new ArrayList<Extractor>();
        Object current = "";
        boolean previousWasBackslash = false;
        boolean variableBusy = false;
        if (template != null) {
            char[] cArray = template.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                if (c.charValue() == '{') {
                    if (previousWasBackslash) {
                        current = (String)current + c;
                        previousWasBackslash = false;
                        continue;
                    }
                    if (variableBusy) {
                        throw new Error("Parsing of template failed. Probably a { was followed by a second { without first closing the first {. Make sure that you use { and } correctly.");
                    }
                    variableBusy = true;
                    if (!((String)current).equals("")) {
                        extractors.add(new ConstantExtractor((String)current));
                    }
                    current = "";
                    continue;
                }
                if (c.charValue() == '}') {
                    if (previousWasBackslash) {
                        current = (String)current + c;
                        previousWasBackslash = false;
                        continue;
                    }
                    if (variableBusy) {
                        extractors.add(new ReferenceExtractor((String)current, ignoreDoubleQuotes, strictReferenceResolution));
                        current = "";
                        variableBusy = false;
                        continue;
                    }
                    throw new Error("Parsing of template failed. Probably a } as used before a { was used. Make sure that you use { and } correctly.");
                }
                if (c.charValue() == '\\') {
                    if (previousWasBackslash) {
                        previousWasBackslash = false;
                        current = (String)current + c;
                        continue;
                    }
                    previousWasBackslash = true;
                    continue;
                }
                current = (String)current + c;
            }
            if (!((String)current).equals("")) {
                extractors.add(new ConstantExtractor((String)current));
            }
        }
        return extractors;
    }

    public static String randomString(int len) {
        String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(AB.charAt(rnd.nextInt(AB.length())));
        }
        return sb.toString();
    }

    public static String hashCode(String s) {
        int hash = 0;
        for (int i = 0; i < s.toCharArray().length; ++i) {
            hash += s.toCharArray()[i] * 31 ^ s.toCharArray().length - 1 - i;
        }
        return Integer.toString(Math.abs(hash));
    }

    public static void ntriples2hdt(String rdfInputPath, String hdtOutputPath) {
        String baseURI = "http://example.com/mydataset";
        String inputType = "ntriples";
        try {
            HDT hdt = HDTManager.generateHDT((String)rdfInputPath, (String)baseURI, (RDFNotation)RDFNotation.parse((String)inputType), (HDTOptions)new HDTSpecification(), null);
            hdt.saveToHDT(hdtOutputPath, null);
            hdt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isValidIRI(String iri) {
        try {
            new ParsedIRI(iri);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isRelativeIRI(String iri) {
        try {
            ParsedIRI parsedIRI = new ParsedIRI(iri);
            return !parsedIRI.isAbsolute();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkPathParent(String path, String base) {
        File basePath;
        File f;
        if (base == null) {
            f = new File(path);
            if (f.isAbsolute()) {
                return f.getParentFile().exists();
            }
            base = System.getProperty("user.dir");
        }
        try {
            basePath = new File(base);
        }
        catch (Exception e) {
            return false;
        }
        logger.info("Looking for parent of file {} in basePath {}", (Object)path, (Object)basePath);
        f = new File(basePath, path);
        return f.getParentFile().exists();
    }

    public static String getBaseDirectiveTurtleOrDefault(InputStream is, String defaultBase) {
        String turtle;
        try {
            turtle = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            turtle = "";
        }
        String base = Utils.getBaseDirectiveTurtle(turtle);
        if (base == null) {
            base = defaultBase;
        }
        return base;
    }

    public static String getBaseDirectiveTurtle(String turtle) {
        Pattern p = Pattern.compile("@base <([^<>]*)>");
        Matcher m = p.matcher(turtle);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static String transformDatatypeString(String input, String datatype) {
        switch (datatype) {
            case "http://www.w3.org/2001/XMLSchema#hexBinary": {
                return input;
            }
            case "http://www.w3.org/2001/XMLSchema#decimal": {
                return "" + Double.parseDouble(input);
            }
            case "http://www.w3.org/2001/XMLSchema#integer": {
                return "" + Integer.parseInt(input);
            }
            case "http://www.w3.org/2001/XMLSchema#double": {
                return Utils.formatToScientific(Double.parseDouble(input));
            }
            case "http://www.w3.org/2001/XMLSchema#boolean": {
                switch (input) {
                    case "t": 
                    case "true": 
                    case "TRUE": 
                    case "1": {
                        return "true";
                    }
                }
                return "false";
            }
            case "http://www.w3.org/2001/XMLSchema#date": {
                return input;
            }
            case "http://www.w3.org/2001/XMLSchema#time": {
                return input;
            }
            case "http://www.w3.org/2001/XMLSchema#dateTime": {
                return input.replace(" ", "T");
            }
        }
        return input;
    }

    public static int getHashOfString(String str) {
        int hash = 7;
        for (int i = 0; i < str.length(); ++i) {
            hash = hash * 31 + str.charAt(i);
        }
        return hash;
    }

    private static String formatToScientific(Double d) {
        BigDecimal input = BigDecimal.valueOf(d).stripTrailingZeros();
        int precision = input.scale() < 0 ? input.precision() - input.scale() : input.precision();
        StringBuilder s = new StringBuilder("0.0");
        for (int i = 2; i < precision; ++i) {
            s.append("#");
        }
        s.append("E0");
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(s.toString());
        return df.format(d);
    }
}

