/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml;

import be.ugent.idlab.knows.dataio.access.LocalFileAccess;
import be.ugent.idlab.knows.dataio.access.RemoteFileAccess;
import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.rml.Initializer;
import be.ugent.rml.Mapping;
import be.ugent.rml.MappingInfo;
import be.ugent.rml.MappingOptimizer;
import be.ugent.rml.POGFunction;
import be.ugent.rml.PredicateObjectGraph;
import be.ugent.rml.PredicateObjectGraphMapping;
import be.ugent.rml.StrictMode;
import be.ugent.rml.Utils;
import be.ugent.rml.conformer.MappingConformer;
import be.ugent.rml.functions.MultipleRecordsFunctionExecutor;
import be.ugent.rml.metadata.Metadata;
import be.ugent.rml.metadata.MetadataGenerator;
import be.ugent.rml.records.MarkerRecord;
import be.ugent.rml.records.RecordsFactory;
import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.store.RDF4JStore;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.ProvenancedQuad;
import be.ugent.rml.term.ProvenancedTerm;
import be.ugent.rml.term.Term;
import be.ugent.rml.termgenerator.TermGenerator;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger logger = LoggerFactory.getLogger(Executor.class);
    private final Initializer initializer;
    private final MappingOptimizer mappingOptimizer;
    private final Map<Term, List<Record>> recordsHolders = new HashMap<Term, List<Record>>();
    private final Map<Term, Map<Integer, List<ProvenancedTerm>>> subjectCache;
    private final QuadStore resultingQuads;
    private final QuadStore rmlStore;
    private final Map<Term, QuadStore> targetStores;
    private final RecordsFactory recordsFactory;
    private static int blankNodeCounter;
    private final Map<Term, Mapping> mappings;
    private boolean EOFProvidedInData = false;

    public Executor(QuadStore rmlStore, RecordsFactory recordsFactory, String baseIRI, StrictMode strictMode, Agent functionAgent) throws Exception {
        this(rmlStore, recordsFactory, null, baseIRI, strictMode, functionAgent);
    }

    public Executor(QuadStore rmlStore, RecordsFactory recordsFactory, QuadStore resultingQuads, String baseIRI, Agent functionAgent) throws Exception {
        this(rmlStore, recordsFactory, resultingQuads, baseIRI, StrictMode.BEST_EFFORT, functionAgent);
    }

    public void setEOFProvidedInData() {
        this.EOFProvidedInData = true;
    }

    public Executor(QuadStore rmlStore, RecordsFactory recordsFactory, QuadStore resultingQuads, String baseIRI, StrictMode strictMode, Agent functionAgent) throws Exception {
        this(rmlStore, recordsFactory, resultingQuads, baseIRI, strictMode, functionAgent, null);
    }

    public Executor(QuadStore rmlStore, RecordsFactory recordsFactory, QuadStore resultingQuads, String baseIRI, StrictMode strictMode, Agent functionAgent, Map<String, String> mappingOptions) throws Exception {
        MappingConformer conformer = new MappingConformer(rmlStore, mappingOptions);
        try {
            boolean conversionNeeded = conformer.conform();
            if (conversionNeeded) {
                logger.info("Conversion to RML was needed.");
            }
        }
        catch (Exception e) {
            logger.error("Failed to make mapping file conformant to RML spec.", (Throwable)e);
        }
        this.mappingOptimizer = new MappingOptimizer(rmlStore);
        this.rmlStore = this.mappingOptimizer.optimizeMapping();
        this.initializer = new Initializer(this.rmlStore, functionAgent, baseIRI, strictMode);
        this.mappings = this.initializer.getMappings();
        this.recordsFactory = recordsFactory;
        this.subjectCache = new HashMap<Term, Map<Integer, List<ProvenancedTerm>>>();
        this.targetStores = new HashMap<Term, QuadStore>();
        blankNodeCounter = 0;
        this.resultingQuads = Objects.requireNonNullElseGet(resultingQuads, RDF4JStore::new);
        for (Map.Entry<Term, Mapping> tm : this.mappings.entrySet()) {
            Mapping mapping = tm.getValue();
            MappingInfo subjectMapInfo = mapping.getSubjectMappingInfo();
            HashSet<Term> targets = new HashSet<Term>(subjectMapInfo.getTargets());
            for (PredicateObjectGraphMapping pog : mapping.getPredicateObjectGraphMappings()) {
                if (pog.getPredicateMappingInfo() != null) {
                    targets.addAll(pog.getPredicateMappingInfo().getTargets());
                }
                if (pog.getObjectMappingInfo() != null) {
                    targets.addAll(pog.getObjectMappingInfo().getTargets());
                }
                if (pog.getGraphMappingInfo() == null) continue;
                targets.addAll(pog.getGraphMappingInfo().getTargets());
            }
            for (MappingInfo g : mapping.getGraphMappingInfos()) {
                targets.addAll(g.getTargets());
            }
            for (Term t : targets) {
                logger.debug("Adding target for {}", (Object)t);
                this.targetStores.put(t, new RDF4JStore());
            }
        }
    }

    public Map<Term, QuadStore> execute(List<Term> triplesMaps, boolean removeDuplicates, MetadataGenerator metadataGenerator) throws Exception {
        POGFunction pogFunction = metadataGenerator != null && metadataGenerator.getDetailLevel().getLevel() >= MetadataGenerator.DETAIL_LEVEL.TRIPLE.getLevel() ? (subject, predicate, object, graph, checkEOFMarker) -> {
            if (this.generateQuad(subject, predicate, object, graph, checkEOFMarker)) {
                metadataGenerator.insertQuad(new ProvenancedQuad(subject, predicate, object, graph));
            }
        } : this::generateQuad;
        return this.executeWithFunction(triplesMaps, removeDuplicates, pogFunction);
    }

    public Map<Term, QuadStore> executeWithFunction(List<Term> triplesMaps, boolean removeDuplicates, POGFunction pogFunction) throws Exception {
        if (triplesMaps == null || triplesMaps.isEmpty()) {
            triplesMaps = this.getTriplesMaps();
        }
        for (Term triplesMap : triplesMaps) {
            TermGenerator generator;
            boolean needsEOFMarker;
            Mapping mapping = this.mappings.get(triplesMap);
            List<Record> records = this.getRecords(triplesMap);
            for (int j = 0; j < records.size(); ++j) {
                Record record = records.get(j);
                List<ProvenancedTerm> subjects = this.getSubject(triplesMap, mapping, record, j);
                if (subjects == null) continue;
                this.generatePredicateObjectsForSubjects(subjects, mapping, record, pogFunction, this.EOFProvidedInData);
            }
            if (this.EOFProvidedInData || !(needsEOFMarker = (generator = mapping.getSubjectMappingInfo().getTermGenerator()).needsEOFMarker())) continue;
            MarkerRecord record = new MarkerRecord();
            ArrayList<ProvenancedTerm> subjects = new ArrayList<ProvenancedTerm>();
            List<Term> nodes = generator.generate(record);
            if (!nodes.isEmpty()) {
                List<Term> subjectTargets = this.getAllTargets(mapping.getSubjectMappingInfo(), record);
                for (Term node : nodes) {
                    subjects.add(new ProvenancedTerm(node, null, subjectTargets));
                }
            }
            this.generatePredicateObjectsForSubjects(subjects, mapping, null, pogFunction, true);
        }
        if (removeDuplicates) {
            this.resultingQuads.removeDuplicates();
        }
        this.targetStores.put(new NamedNode("rmlmapper://default.store"), this.resultingQuads);
        return this.targetStores;
    }

    public Map<Term, QuadStore> execute(List<Term> triplesMaps) throws Exception {
        return this.execute(triplesMaps, false, null);
    }

    private boolean generateQuad(ProvenancedTerm subject, ProvenancedTerm predicate, ProvenancedTerm object, ProvenancedTerm graph, boolean checkEOFMarker) {
        Term g = null;
        HashSet<Term> targets = new HashSet<Term>();
        if (subject != null && predicate != null && object != null) {
            if (graph != null) {
                g = graph.getTerm();
                targets.addAll(graph.getTargets());
            }
            if (checkEOFMarker) {
                if (subject.getTerm().getValue().contains("!@#$%^&()_+") || subject.getTerm().getValue().contains("%21%40%23%24%25%5E%26%28%29_%2B") || predicate.getTerm().getValue().contains("!@#$%^&()_+") || predicate.getTerm().getValue().contains("%21%40%23%24%25%5E%26%28%29_%2B") || object.getTerm().getValue().contains("!@#$%^&()_+") || object.getTerm().getValue().contains("%21%40%23%24%25%5E%26%28%29_%2B")) {
                    return false;
                }
                if (g != null && (g.getValue().contains("!@#$%^&()_+") || g.getValue().contains("%21%40%23%24%25%5E%26%28%29_%2B"))) {
                    return false;
                }
            }
            targets.addAll(subject.getTargets());
            targets.addAll(predicate.getTargets());
            targets.addAll(object.getTargets());
            if (!targets.isEmpty()) {
                for (Term t : targets) {
                    this.targetStores.get(t).addQuad(subject.getTerm(), predicate.getTerm(), object.getTerm(), g);
                }
            } else {
                this.resultingQuads.addQuad(subject.getTerm(), predicate.getTerm(), object.getTerm(), g);
            }
            return true;
        }
        return false;
    }

    private List<ProvenancedTerm> getIRIsWithConditions(Record record, Term triplesMap, List<MultipleRecordsFunctionExecutor> conditions) throws Exception {
        ArrayList<ProvenancedTerm> goodIRIs = new ArrayList<ProvenancedTerm>();
        ArrayList<List<ProvenancedTerm>> allIRIs = new ArrayList<List<ProvenancedTerm>>();
        for (MultipleRecordsFunctionExecutor condition : conditions) {
            allIRIs.add(this.getIRIsWithTrueCondition(record, triplesMap, condition));
        }
        if (!allIRIs.isEmpty()) {
            goodIRIs.addAll((Collection)allIRIs.get(0));
            for (int i = 1; i < allIRIs.size(); ++i) {
                List list = (List)allIRIs.get(i);
                for (int j = 0; j < goodIRIs.size(); ++j) {
                    if (list.contains(goodIRIs.get(j))) continue;
                    goodIRIs.remove(j);
                    --j;
                }
            }
        }
        return goodIRIs;
    }

    private List<ProvenancedTerm> getIRIsWithTrueCondition(Record child, Term triplesMap, MultipleRecordsFunctionExecutor condition) throws Exception {
        Mapping mapping = this.mappings.get(triplesMap);
        List<Record> records = this.getRecords(triplesMap);
        ArrayList<ProvenancedTerm> iris = new ArrayList<ProvenancedTerm>();
        for (int i = 0; i < records.size(); ++i) {
            Record parent = records.get(i);
            HashMap<String, Record> recordsMap = new HashMap<String, Record>();
            recordsMap.put("child", child);
            recordsMap.put("parent", parent);
            Object expectedBoolean = condition.execute(recordsMap);
            if (Boolean.TRUE.equals(expectedBoolean)) {
                List<ProvenancedTerm> subjects = this.getSubject(triplesMap, mapping, parent, i);
                if (subjects == null) continue;
                iris.addAll(subjects);
                continue;
            }
            logger.warn("The used condition with the Parent Triples Map does not return a boolean.");
        }
        return iris;
    }

    private List<ProvenancedTerm> getSubject(Term triplesMap, Mapping mapping, Record record, int i) throws Exception {
        TermGenerator generator;
        List<Term> nodes;
        if (!this.subjectCache.containsKey(triplesMap)) {
            this.subjectCache.put(triplesMap, new HashMap());
        }
        if (!this.subjectCache.get(triplesMap).containsKey(i) && !(nodes = (generator = mapping.getSubjectMappingInfo().getTermGenerator()).generate(record)).isEmpty()) {
            List<Term> subjectTargets = this.getAllTargets(mapping.getSubjectMappingInfo(), record);
            ArrayList<ProvenancedTerm> terms = new ArrayList<ProvenancedTerm>();
            Metadata meta = new Metadata(triplesMap, mapping.getSubjectMappingInfo().getTerm());
            for (Term node : nodes) {
                terms.add(new ProvenancedTerm(node, meta, subjectTargets));
            }
            this.subjectCache.get(triplesMap).put(i, terms);
            return terms;
        }
        return this.subjectCache.get(triplesMap).get(i);
    }

    private List<ProvenancedTerm> getAllIRIs(Term triplesMap) throws Exception {
        Mapping mapping = this.mappings.get(triplesMap);
        List<Record> records = this.getRecords(triplesMap);
        ArrayList<ProvenancedTerm> iris = new ArrayList<ProvenancedTerm>();
        for (int i = 0; i < records.size(); ++i) {
            Record record = records.get(i);
            List<ProvenancedTerm> subjects = this.getSubject(triplesMap, mapping, record, i);
            if (subjects == null) continue;
            iris.addAll(subjects);
        }
        return iris;
    }

    private List<Record> getRecords(Term triplesMap) throws Exception {
        if (!this.recordsHolders.containsKey(triplesMap)) {
            this.recordsHolders.put(triplesMap, this.recordsFactory.createRecords(triplesMap, this.rmlStore));
        }
        return this.recordsHolders.get(triplesMap);
    }

    private List<PredicateObjectGraph> combineMultiplePOGs(List<ProvenancedTerm> predicates, List<ProvenancedTerm> objects, List<ProvenancedTerm> graphs) {
        ArrayList<PredicateObjectGraph> results = new ArrayList<PredicateObjectGraph>();
        if (graphs.isEmpty()) {
            graphs.add(null);
        }
        predicates.forEach(p -> objects.forEach(o -> graphs.forEach(g -> {
            if (g != null && g.getTerm().equals(new NamedNode("http://w3id.org/rml/defaultGraph"))) {
                results.add(new PredicateObjectGraph((ProvenancedTerm)p, (ProvenancedTerm)o, null));
            } else {
                results.add(new PredicateObjectGraph((ProvenancedTerm)p, (ProvenancedTerm)o, (ProvenancedTerm)g));
            }
        })));
        return results;
    }

    public static String getNewBlankNodeID() {
        String temp = "" + blankNodeCounter;
        ++blankNodeCounter;
        return temp;
    }

    public List<Term> getTriplesMaps() {
        List<Quad> withSubjectMaps = this.rmlStore.getQuads(null, new NamedNode("http://w3id.org/rml/subjectMap"), null);
        return withSubjectMaps.stream().map(Quad::getSubject).filter(subject -> this.rmlStore.contains((Term)subject, new NamedNode("http://w3id.org/rml/logicalSource"), null)).toList();
    }

    public QuadStore getRMLStore() {
        return this.rmlStore;
    }

    public Map<Term, QuadStore> getTargets() {
        if (this.targetStores.isEmpty()) {
            return null;
        }
        return this.targetStores;
    }

    public void verifySources(String basepath, String mappingPath) throws Exception {
        for (Term triplesMap : this.getTriplesMaps()) {
            List<Term> logicalSources = Utils.getObjectsFromQuads(this.rmlStore.getQuads(triplesMap, new NamedNode("http://w3id.org/rml/logicalSource"), null));
            Term logicalSource = logicalSources.get(0);
            List<Term> sources = Utils.getObjectsFromQuads(this.rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/source"), null));
            for (Term source : sources) {
                InputStream is;
                String value = source.getValue();
                if (!(source instanceof Literal)) continue;
                if (Utils.isRemoteFile(value)) {
                    is = new RemoteFileAccess(value).getInputStream();
                } else {
                    try {
                        is = new LocalFileAccess(value, basepath, ((Literal)source).getDatatype().stringValue()).getInputStream();
                    }
                    catch (NoSuchFileException e) {
                        is = new LocalFileAccess(value, mappingPath, ((Literal)source).getDatatype().stringValue()).getInputStream();
                    }
                }
                is.close();
            }
        }
    }

    private void generatePredicateObjectsForSubjects(List<ProvenancedTerm> subjects, Mapping mapping, Record record, POGFunction pogFunction, boolean checkEOFMarker) throws Exception {
        for (ProvenancedTerm subject : subjects) {
            if (subject == null) continue;
            ArrayList subjectGraphs = new ArrayList();
            mapping.getGraphMappingInfos().forEach(mappingInfo -> {
                List<Term> terms = null;
                try {
                    terms = mappingInfo.getTermGenerator().generate(record);
                }
                catch (Exception e) {
                    logger.error("Could not generate graph term for record {}", (Object)record, (Object)e);
                }
                if (terms != null) {
                    terms.forEach(term -> {
                        if (!term.equals(new NamedNode("http://w3id.org/rml/defaultGraph"))) {
                            List<Term> subjectGraphTargets = this.getAllTargets((MappingInfo)mappingInfo, record);
                            subjectGraphs.add(new ProvenancedTerm((Term)term, null, subjectGraphTargets));
                        }
                    });
                }
            });
            ArrayList<PredicateObjectGraph> pogs = new ArrayList<PredicateObjectGraph>();
            List<PredicateObjectGraphMapping> predicateObjectGraphMappings = mapping.getPredicateObjectGraphMappings();
            for (PredicateObjectGraphMapping pogMapping : predicateObjectGraphMappings) {
                List<ProvenancedTerm> objects;
                TermGenerator pogGraphGenerator;
                ArrayList<ProvenancedTerm> predicates = new ArrayList<ProvenancedTerm>();
                MappingInfo pogGraphMappingInfo = pogMapping.getGraphMappingInfo();
                MappingInfo pogPredicateMappingInfo = pogMapping.getPredicateMappingInfo();
                MappingInfo pogObjectMappingInfo = pogMapping.getObjectMappingInfo();
                ArrayList<ProvenancedTerm> poGraphs = new ArrayList<ProvenancedTerm>(subjectGraphs);
                if (pogGraphMappingInfo != null && (pogGraphGenerator = pogGraphMappingInfo.getTermGenerator()) != null) {
                    pogGraphGenerator.generate(record).forEach(term -> {
                        List<Term> graphTargets = this.getAllTargets(pogGraphMappingInfo, record);
                        poGraphs.add(new ProvenancedTerm((Term)term, null, graphTargets));
                    });
                }
                if (pogPredicateMappingInfo != null) {
                    TermGenerator pogPredicateGenerator = pogPredicateMappingInfo.getTermGenerator();
                    List<Term> predicateTargets = this.getAllTargets(pogPredicateMappingInfo, record);
                    pogPredicateGenerator.generate(record).forEach(p -> {
                        Metadata meta = new ProvenancedTerm((Term)p, pogPredicateMappingInfo).getMetadata();
                        predicates.add(new ProvenancedTerm((Term)p, meta, predicateTargets));
                    });
                }
                if (pogObjectMappingInfo != null) {
                    TermGenerator pogObjectGenerator = pogObjectMappingInfo.getTermGenerator();
                    if (pogObjectGenerator == null) continue;
                    List<Term> objects2 = pogObjectGenerator.generate(record);
                    List<Term> objectTargets = this.getAllTargets(pogObjectMappingInfo, record);
                    ArrayList<ProvenancedTerm> provenancedObjects = new ArrayList<ProvenancedTerm>();
                    objects2.forEach(object -> {
                        Metadata meta = new ProvenancedTerm((Term)object, pogObjectMappingInfo).getMetadata();
                        provenancedObjects.add(new ProvenancedTerm((Term)object, meta, objectTargets));
                    });
                    if (objects2.isEmpty()) continue;
                    pogs.addAll(this.combineMultiplePOGs(predicates, provenancedObjects, poGraphs));
                    continue;
                }
                if (pogMapping.getParentTriplesMap() == null) continue;
                if (!pogMapping.getJoinConditions().isEmpty()) {
                    logger.debug("mapping {}'s join conditions are not empty", (Object)pogMapping.toString());
                    objects = this.getIRIsWithConditions(record, pogMapping.getParentTriplesMap(), pogMapping.getJoinConditions());
                } else {
                    logger.debug("mapping {}'s join conditions are empty", (Object)pogMapping.toString());
                    objects = this.getAllIRIs(pogMapping.getParentTriplesMap());
                }
                pogs.addAll(this.combineMultiplePOGs(predicates, objects, poGraphs));
            }
            pogs.forEach(pog -> pogFunction.generateQuad(subject, pog.getPredicate(), pog.getObject(), pog.getGraph(), checkEOFMarker));
        }
    }

    private List<Term> getAllTargets(MappingInfo mappingInfo, Record record) {
        ArrayList<Term> allTargets = new ArrayList<Term>();
        allTargets.addAll(this.generateTargetsAndAddToTargetStore(mappingInfo, record));
        allTargets.addAll(mappingInfo.getTargets());
        return allTargets;
    }

    private List<Term> generateTargetsAndAddToTargetStore(MappingInfo mappingInfo, Record record) {
        List<TermGenerator> targetGenerators = mappingInfo.getTargetGenerators();
        ArrayList<Term> generatedTargets = new ArrayList<Term>();
        for (TermGenerator targetGenerator : targetGenerators) {
            try {
                generatedTargets.addAll(targetGenerator.generate(record));
            }
            catch (Exception e) {
                logger.error("Error occurred when generating target", (Throwable)e);
            }
        }
        for (Term generatedTarget : generatedTargets) {
            if (this.targetStores.containsKey(generatedTarget)) continue;
            this.targetStores.put(generatedTarget, new RDF4JStore());
        }
        return generatedTargets;
    }
}

